//
//     W M S E R I A L - Windows Modem Example
//
// This is only part of a multiple source project.  To build the
// executable please use the makefile provided or construct
// a project file containing the files and settings listed in
// PROJECT.TXT.
//
// Remember to modify the directories to reflect your configuration.
//
//                                                     - J A A

// WMODEM.C

#include <windows.h>
#include <string.h>    // for strstr
#include "wmserial.h"


char ModemResponse[13][20] = 
   {
	"OK\r\n",
	"CONNECT\r\n",
	"RING\r\n",
	"NO CARRIER\r\n",
	"ERROR\r\n",
	"NO DIAL TONE\r\n",
	"BUSY\r\n",
	"NO ANSWER\r\n",
	"CONNECT 1200\r\n",
	"CONNECT 2400\r\n",
	"CONNECT 4800\r\n",
	"CONNECT 9600\r\n",
	"CONNECT 14400\r\n"
   };

static HWND hModemWnd;

   
BOOL InitModem(HWND hWnd, int nComID)
   {
   int nResult;
   BOOL bReturnValue;
   HANDLE hBufferMem;
   LPSTR szModemResponse;
   char szInitString[] = "ATZ\r";

   // Save hWnd
   hModemWnd = hWnd;

   // Get memory for response
   hBufferMem = GlobalAlloc( GMEM_MOVEABLE, QBUFFSIZE );
   if (!hBufferMem)
       {
       MessageBeep(MB_ICONEXCLAMATION);
       MessageBox(hWnd,"Not enough memory for initializing modem.","Example Windows Terminal",MB_ICONSTOP);
       SendMessage(hWnd,WM_CLOSE,0,0L);
       return FALSE;
       }

   szModemResponse = (LPSTR) GlobalLock(hBufferMem);

   // Send Initialization String
   nResult = WriteComPort(nComID,szInitString,lstrlen(szInitString));
   TTYWriteScreen(szInitString);
   CheckComPort(nComID,NULL);
   if (nResult < 0)
       {
       GlobalUnlock(hBufferMem);
       return FALSE;
       }

   // Get the response
   nResult = GetModemResponse(nComID,szModemResponse,QBUFFSIZE,30);
   CheckComPort(nComID,NULL);
   if (nResult <= 0) 
       {
       GlobalUnlock(hBufferMem);
       return FALSE;
       }
   else
       TTYWriteScreen(szModemResponse);

   if (strstr(szModemResponse,"OK\r\n"))
       bReturnValue = TRUE;
   else
       bReturnValue = FALSE;

   GlobalUnlock(hBufferMem);
   return bReturnValue;
   }



int HangUpModem(int nComID)
   {
   DWORD StartTick;
   char szCloseString[] = "ATH0\r";

   // Force polled communication
   EnableCommNotification(nComID,NULL,NULL,NULL);

   // Get back to command mode.
   StartTick = GetTickCount();
   while (StartTick+1000 > GetTickCount());
   WriteComPort(nComID,"+++",3);
   StartTick = GetTickCount();
   while (StartTick+1000 > GetTickCount());

   // Send Hangup String
   WriteComPort(nComID,szCloseString,lstrlen(szCloseString));

   return NULL;
   }



int GetModemResponse(int nComID, LPSTR szDest, int nMaxLength, int Wait)
   {
   int nResult;
   int CurrIndex, i;
   DWORD StartTick;
   BOOL Match = FALSE;

   // Force polled communication
   EnableCommNotification(nComID,NULL,NULL,NULL);

   CurrIndex = 0;
   szDest[0] = 0;
   StartTick = GetTickCount();
   do
       {
       nResult = ReadComPort(nComID, &szDest[CurrIndex], nMaxLength-lstrlen(szDest));
       if (nResult < 0)
           {
           CurrIndex -= nResult;
           szDest[CurrIndex] = 0;
           }
       else if (nResult > 0)
           {
           CurrIndex += nResult;
           szDest[CurrIndex] = 0;

           // Quit if acceptable response in stringtable
           for (i = 0; i < 13; i++)
               {
               if ( strstr(szDest,ModemResponse[i]) )
                   {
                   Match = TRUE;
                   break;
                   }
               }
           }
       } while (!Match && nResult >= 0 && 
                StartTick + (DWORD) Wait * 1000 > GetTickCount() );

   if (nResult >= 0 && !Match)
       MessageBox(hModemWnd,"Modem Timed Out.","Example Windows Terminal",MB_OK);

   if (nResult < 0)
       return -lstrlen(szDest);
   else
       return lstrlen(szDest);
   }



