#include <windows.h>

#define USER_DISCONNECT	101
#define WM_CONNECT     (WM_USER+1)

#define QBUFFSIZE      4096

#define COMPORT        "COM3"
#define BAUDRATE       "2400"
#define PARITY         "N"
#define DATABITS       "8"
#define STOPBITS       "1"

extern int nActiveComPort;
extern BOOL bConnected;
extern BOOL bEcho;

// Function declarations


// Window functions ( WMSERIAL.CPP )

HWND InitWinApp(HANDLE hInstance, HANDLE hPrevious,
					LPSTR lpszCmdLine, int nCmdShow);

LRESULT CALLBACK _export WndProc (HWND hWnd, UINT message,
											 WPARAM wParam, LPARAM lParam);



// Process Comm Notification Procedure ( WNOTIFY.CPP )

int ProcessCommNotify(HWND hWnd, int nComID, int nNotification);



// High level communication functions ( WCONNECT.CPP )

BOOL Connect(HWND);
BOOL Dial(void);
void Disconnect(void);



// Modem functions ( WMODEM.CPP )

BOOL InitModem(HWND hWnd, int nComID);
int GetModemResponse(int nComID, LPSTR szDest, int nMaxLength, int Wait);
int HangUpModem(int nComID);



// Com Port functions ( WCOM.CPP )

int InitComPort( HWND hWnd, LPSTR ComName );
int CloseComPort( int nComID );
int ReadComPort( int nComID , LPSTR Data , int nMaxLength );
int WriteComPort( int nComID , LPSTR Data , int nLength );
int CheckComPort( int nComID , COMSTAT *Status );


// TTY functions ( WTTY.CPP )

void TTYInit( HWND hWnd );
void TTYSetFocus( void );
void TTYWriteScreen( LPSTR lpOutString );












