//
//     W M S E R I A L - Windows Modem Example
//
// This is only part of a multiple source project.  To build the
// executable please use the makefile provided or construct
// a project file containing the files and settings listed in
// PROJECT.TXT.
//
// Remember to modify the directories to reflect your configuration.
//
//                                                     - J A A

// WMSERIAL.C

#define _MAIN
#include <windows.h>
#include "wmserial.h"


char szAppName[] = "WMSERIAL";

#pragma argsused

int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevious,
                   LPSTR lpszCmdLine, int nCmdShow )
   {
   MSG msg;
   HWND hWnd;

   hWnd = InitWinApp( hInstance,hPrevious,lpszCmdLine,nCmdShow );
   if (!hWnd)
       {
       MessageBeep( MB_ICONEXCLAMATION );
       MessageBox( NULL,"Could not create main window.","Example Windows Terminal",MB_ICONSTOP );
       return FALSE;
       }


   while (GetMessage(&msg,NULL,0,0))
       {
       TranslateMessage(&msg);
       DispatchMessage(&msg);
       }

   return msg.wParam;
   }



#pragma argsused

HWND InitWinApp( HANDLE hInstance, HANDLE hPrevious,
               LPSTR lpszCmdLine, int nCmdShow )
   {
   HWND hwnd;
   WNDCLASS wndclass;
                           
   if ( !hPrevious )
       {                     
       wndclass.style       = CS_HREDRAW | CS_VREDRAW;
       wndclass.lpfnWndProc = WndProc;
       wndclass.cbClsExtra  = 0;
       wndclass.cbWndExtra  = 0;
       wndclass.hInstance   = hInstance;
       wndclass.hIcon       = LoadIcon( NULL, IDI_APPLICATION );
       wndclass.hCursor     = LoadCursor( NULL, IDC_ARROW );
       wndclass.hbrBackground = GetStockObject( WHITE_BRUSH );
       wndclass.lpszMenuName = szAppName;
       wndclass.lpszClassName = szAppName;

       if ( !RegisterClass ( &wndclass ) ) return NULL;
       }

   hwnd = CreateWindow( szAppName,"Example Windows Terminal",
                       WS_OVERLAPPED|WS_VISIBLE|WS_MAXIMIZE,
                       CW_USEDEFAULT, CW_USEDEFAULT,
                       CW_USEDEFAULT, CW_USEDEFAULT,
                       NULL, NULL, hInstance, NULL );

   if (!hwnd) return NULL;

   ShowWindow( hwnd, SW_SHOWMAXIMIZED );
   UpdateWindow(hwnd);            

   return hwnd;
   }




LRESULT CALLBACK _export WndProc ( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam )
   {
   char szTemp[3];

   switch( message ) 
       {

       case WM_CREATE:
           TTYInit( hWnd );
           PostMessage( hWnd,WM_CONNECT,0,0L );
           return 0;



       case WM_CONNECT:
           if ( !Connect( hWnd ) )
               PostMessage( hWnd,WM_CLOSE,0,0L );
           return 0;



       case WM_COMMNOTIFY:
           ProcessCommNotify( hWnd, wParam, LOWORD( lParam ));
           CheckComPort( wParam,NULL );
           return 0;



       case WM_COMMAND:
           switch ( wParam )
               {
               case USER_DISCONNECT:
                   PostMessage( hWnd, WM_CLOSE, 0, 0L );
                   break;
               }
           return 0;


                   
       case WM_SETFOCUS:
           TTYSetFocus();
           return 0;



       case WM_KILLFOCUS:
           HideCaret( hWnd );
           DestroyCaret();
           return 0;



       case WM_KEYDOWN:
           switch (wParam)
               {
               case VK_RETURN:
                   WriteComPort( nActiveComPort,"\r",1 );
                   CheckComPort( nActiveComPort,NULL );
                   if (bEcho)
                       TTYWriteScreen("\r\n");
                   return 0;

               default:
                   return( DefWindowProc( hWnd, message, wParam, lParam ) );
               }



       case WM_CHAR:
           // process keystrokes
           switch( wParam ) 
               {
               case '\r':
               case '\n':
                   break;

               default:
                   szTemp[0] = (char)wParam;
                   szTemp[1] = '\0';
                   WriteComPort( nActiveComPort,szTemp,1 );
                   CheckComPort( nActiveComPort,NULL );
                   if (bEcho)
                       TTYWriteScreen( szTemp );
                   break;
               }
           return 0;

       case WM_CLOSE:
           Disconnect();
           DestroyWindow( hWnd );
           PostQuitMessage( 0 );
           return 0;

       default:
           return( DefWindowProc( hWnd, message, wParam, lParam ) );
       }
   }







