// *************************************************************** //
// Filename:    MyMDI.h                                            //
//                                                                 //
// Date:        November 26, 1993                                  //
//                                                                 //
// Description:                                                    //
// *************************************************************** //

#ifndef MyMDI_H
#define MyMDI_H

#include <owl\owlcore.h>
#include <owl\mdi.h>
#include <owl\mdichild.h>
#include <owl\edit.h>
#include <owl\button.h>
#pragma hdrstop
#include "MyMDI.rh"

// --------------------------------------------------------------- //
// MyMDIApplication                                                //
// --------------------------------------------------------------- //
class TMyMDIApp : public TApplication
{
  public:
    TMyMDIApp();
   ~TMyMDIApp();
    void InitMainWindow();
};

// --------------------------------------------------------------- //
// MyMDIClient                                                     //
// --------------------------------------------------------------- //
class TMyMDIClient : public TMDIClient
{
  public:
    TMyMDIClient(TModule *module = 0);
   ~TMyMDIClient();

    void SetupWindow();
    void CleanupWindow();
  
    TMDIChild* InitChild();
    DECLARE_RESPONSE_TABLE(TMyMDIClient);
};

// --------------------------------------------------------------- //
// MyMDIChild                                                      //
// --------------------------------------------------------------- //
class TMyMDIChild : public TMDIChild
{
  public:
	 TMyMDIChild(TMDIClient &parent, const char far *title = 0,
		TWindow *clientWnd = 0, BOOL shrinkToClient = FALSE,
		TModule *module = 0);
	~TMyMDIChild();

	 void GetWindowClass(WNDCLASS& wndClass);
	 char *GetClassName();
	 void SetupWindow();
	 void CleanupWindow();

	 DECLARE_RESPONSE_TABLE(TMyMDIChild);
};


// --------------------------------------------------------------- //
// Edit Box                                                        //
// --------------------------------------------------------------- //
class TMyEdit : public TEdit
{
	public:
		 TMyEdit (TWindow * parent, int ResID) : TEdit (parent, ResID) {};
		 void EvLButtonDown(uint modKeys, TPoint& point);

	DECLARE_RESPONSE_TABLE(TMyEdit);
};

// --------------------------------------------------------------- //
// MDI Dialog                                                      //
// --------------------------------------------------------------- //
class TMDIDialog : public TDialog
{
  private:
	 TMyEdit* EditBox;
  protected:
  public:
	 TMDIDialog(TWindow *, TResId);
	~TMDIDialog();
	 void SetupWindow();
	 void CleanupWindow();

	 DECLARE_RESPONSE_TABLE(TMDIDialog);
};

#endif


