// *************************************************************** //
// Filename:    DibView.cpp                                        //
//                                                                 //
// Date:        November 26, 1993                                  //
//                                                                 //
// Description:                                                    //
// *************************************************************** //
#include "DibView.h"
#include <dir.h>

// --------------------------------------------------------------- //
// DibViewWindow constructor                                       //
// --------------------------------------------------------------- //
TDibViewWindow::TDibViewWindow() :
  TWindow(0, 0, 0)
{
  Data = new TOpenSaveDialog::TData(OFN_HIDEREADONLY|OFN_FILEMUSTEXIST,
                                        "Bitmaps (*.bmp)|*.bmp|", 0, "",
                                        "BMP");
  Printer = new TPrinter();
  IsFileSelected = FALSE;
}

// --------------------------------------------------------------- //
// DibViewWindow destructor                                        //
// --------------------------------------------------------------- //
TDibViewWindow::~TDibViewWindow()
{
  delete Data;
  delete Printer;
}

// --------------------------------------------------------------- //
// GetClassName                                                    //
// --------------------------------------------------------------- //
char *TDibViewWindow::GetClassName()
{
  return "DibViewClass";
}

// --------------------------------------------------------------- //
// GetWindowClass                                                  //
// --------------------------------------------------------------- //
void TDibViewWindow::GetWindowClass(WNDCLASS &wc)
{
  TWindow::GetWindowClass(wc);
  wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
}

// --------------------------------------------------------------- //
// SetupWindow                                                     //
// --------------------------------------------------------------- //
void TDibViewWindow::SetupWindow()
{
  TWindow::SetupWindow();
  // put new stuff here
}

// --------------------------------------------------------------- //
// CleanupWindow                                                   //
// --------------------------------------------------------------- //
void TDibViewWindow::CleanupWindow()
{
  // put new stuff here
  TWindow::CleanupWindow();
}

// --------------------------------------------------------------- //
// Response table for DibViewWindow                                //
// --------------------------------------------------------------- //
DEFINE_RESPONSE_TABLE1(TDibViewWindow, TWindow)
  EV_COMMAND(CM_FILEOPEN, CmFileOpen),
  EV_COMMAND(CM_FILEEXIT, CmFileExit),
  EV_WM_PAINT,
  EV_COMMAND_ENABLE(CM_FILEPRINT, EvEnableCmFilePrint),
  EV_COMMAND(CM_FILEPRINT, CmFilePrint),
END_RESPONSE_TABLE;


// --------------------------------------------------------------- //
// CmFileOpen                                                      //
// --------------------------------------------------------------- //
void TDibViewWindow::CmFileOpen()
{
  TFileOpenDialog fileOpenDlg(this, *Data);
  if (fileOpenDlg.Execute() == IDOK)
  {
    IsFileSelected = TRUE;
    Invalidate(TRUE);
  }
}


// --------------------------------------------------------------- //
// CmFileExit                                                      //
// --------------------------------------------------------------- //
void TDibViewWindow::CmFileExit()
{
  PostMessage(WM_CLOSE, 0, 0);
}


// --------------------------------------------------------------- //
// CmFilePrint                                                     //
// --------------------------------------------------------------- //
void TDibViewWindow::CmFilePrint()
{
  TMyPrintout pOut("Print", Data->FileName);
  Printer->Print(this, pOut, TRUE);
}


// --------------------------------------------------------------- //
// EvEnableCmFilePrint                                             //
// --------------------------------------------------------------- //
void TDibViewWindow::EvEnableCmFilePrint(TCommandEnabler &cmdEnabler)
{
  cmdEnabler.Enable(IsFileSelected);
}

// --------------------------------------------------------------- //
// Palette functions                                               //
// --------------------------------------------------------------- //
void TDibViewWindow::EvPaletteChanged(HWND hWndPalChg)
{
  if (HWindow == hWndPalChg)
    return;
  ChangePalette();
}

int TDibViewWindow::ChangePalette()
{
  TWindowDC dc(HWindow);
  int temp = FALSE;

  if (IsFileSelected)
  {
    TDib dib(Data->FileName);
    if (dib.NumColors() != 0)
    {
      TPalette palette(dib);
      dc.SelectObject(palette, TRUE);
      temp = dc.RealizePalette();
      dc.RestorePalette();
      dc.RealizePalette();
      if (temp)
        Invalidate();
    }
  }
  return temp;
}

BOOL TDibViewWindow::EvQueryNewPalette()
{
  return ChangePalette();
}

// --------------------------------------------------------------- //
// EvPaint                                                         //
// --------------------------------------------------------------- //
void TDibViewWindow::EvPaint()
{
  TPaintDC dc(HWindow);

  if (IsFileSelected)
  {
    TDib dib(Data->FileName);
    if (dib.NumColors() != 0)     // bitmap has a palette?
    {
      TPalette palette(dib);
      dc.SelectObject(palette, TRUE);
      dc.RealizePalette();
    }
    DibBitBlt(dc, Data->FileName);
    if (dib.NumColors() != 0)
    {
      dc.RestorePalette();
      dc.RealizePalette();
    }
  }
}


// --------------------------------------------------------------- //
// DibBitBlt                                                       //
// --------------------------------------------------------------- //
void DibBitBlt(TDC &dc, const char *dibFName)
{
  TDib dib(dibFName);
  TRect rect(0, 0, dib.Width(), dib.Height());
  TPoint point(0, 0);
  dc.SetDIBitsToDevice(rect, point, dib);
}
