//----------------------------------------------------------------------------
// For use with ObjectWindows 2 - (C) Copyright Dieter Menne, Biomed Tuebingen
//   Implementation if class TRadioGroupBox.
//   Group box with automatic transfer of Auto Radiobuttons
//----------------------------------------------------------------------------
#include <owl\owlpch.h>
#pragma hdrstop
#include "radiogrp.h">

//
// constructor for a TRadioGroupBox object
//
TRadioGroupBox::TRadioGroupBox( TWindow *parent,
                                int resID,
                                int firstRadioID,
                                int lastRadioID,
                                TModule * Module):
    TGroupBox(parent,resID,Module),
    FromID(firstRadioID),
    ToID(lastRadioID)
{
  // Assumes that the first radiobutton has a group stop
  PRECONDITION(ToID > FromID); // At least 2 !
  PRECONDITION(ToID - FromID < 100); // Probably bad call
  // Keep list of radiobuttons
  RadioButton=new TRadioButton*[ToID-FromID+1];
  for (int id=FromID; id <= ToID; id++)
  {
    RadioButton[id-FromID]= new TRadioButton(parent,id,this,Module);
    RadioButton[id-FromID]->DisableTransfer(); // Because groupbox handles it
  }
  EnableTransfer(); // Let Groupbox handle the transfer
}


UINT TRadioGroupBox::Transfer(void* buffer, TTransferDirection direction)
{
  int id;
  if (direction == tdGetData)
  {
    // scan buttons for the first checked
    for (int id=FromID; id<= ToID; id++)
      if ( RadioButton[id-FromID]->GetCheck())
      {
        *(int*)buffer = id; // Set to first(only?) checked
        break;
      }
  }
  else if (direction == tdSetData)
  {
    id=*(int*)buffer; // Transfer buffer holds active button resID
    if (id < FromID || id > ToID) id=FromID; // Take care for default=0
    RadioButton[id-FromID]->SetCheck(BF_CHECKED);
  }
  return sizeof(int);
}



