/*  Numval.cpp

  Demo program for template generated number validators and
  radio button groups.
  By Dieter Menne, Biomed Software, Tuebingen, Germany
  CIS 100016,2125

  Modifications: Jul-20-94 Uses errno to report overflow
                 Sep-13-94 Removed valtempl.cpp

                 Oct-17-94 Version 2: Needs BC 4.02,
                 because it used PictureValidators now that
                 were broken in BC 4.00. Separate Versions
                 for fixed and scientific float/doubles.
                 Uses right-justified, multiline edit fields.

  Transfer to native-type buffer variables supported -
  you don't need char [] any more to store floats, doubles etc.
  in transfer buffers, and you can use a single int for
  a group of radio buttons.

  To build this program, create a project with the files
    numval.cpp
    radiogrp.cpp
    numval.rc
    numval.def
  Additionally, you should have the following files in
  your directory
    radiogrp.h
    valtempl.h

  For your own project, you need
    valtempl.h for numerical validators
    radiogrp.cpp and radiogrp.h for radio-button groups

  The files numval.* are needed for the demo only.
*/

#include <owl\owlpch.h>
#pragma hdrstop
#include <owl\edit.h>
#include <owl\dialog.h>
#include "radiogrp.h"  // Support radio-button groups
#include "valtempl.h"  // The validator templates
#include "numval.rh"   // Demo Dialog

struct TNumTransfer
{
  // Note that the transfer buffer does not hold char *,
  // but uses the native types instead
  int    TheInt;
  UINT   TheUint;
  float  TheFloat;
  double TheDouble;
  // A group of radio buttons returns one int with the
  // resource ID of the selected alternative
  int   TheRadio;
  // Initialize the buffer
  TNumTransfer(): TheInt(0), TheUint(0),TheFloat(0.0),
       TheDouble(0.) {}
};

// Making a transfer buffer global is not the most elgant
// solution, but Borland's ClassExpert started this bad habit.
// For a real application, pass it in the dialog's constructor.
TNumTransfer NumT;  // Global transfer Buffer

class TNumValDialog: public TDialog
{
  public:
    TNumValDialog();
    void ShowTransfer();
  private:
    TEdit
      *IntEdit,
      *UintEdit,
      *FloatEdit,
      *DoubleEdit;
  DECLARE_RESPONSE_TABLE(TNumValDialog);
};

DEFINE_RESPONSE_TABLE1(TNumValDialog,TDialog)
  EV_COMMAND(IDC_BUTTON1,ShowTransfer),
END_RESPONSE_TABLE;


TNumValDialog::TNumValDialog() : TDialog(0,IDD_VALIDATE)
{
  // The Edit Fields. In the resource, these must have
  // the attribute ES_RIGHT and ES_MULTILINE, because
  // as documented right alignment does not work for
  // single line field. However, there is an undocumented
  // catch: multilines edits with borders must be higher
  // than single-line ones to show the numbers. If a number
  // does not turn up at all, either increase the field
  // height, remove the border, or ask Microsoft why you
  // must do this.

  IntEdit    = new  TEdit(this,IDC_EDIT1,20);
  // UintEdit is a low field without border in the resource
  UintEdit   = new  TEdit(this,IDC_EDIT2,20);
  FloatEdit  = new  TEdit(this,IDC_EDIT3,20);
  DoubleEdit = new  TEdit(this,IDC_EDIT4,20);

  // Set the validators with built-in transfer
  IntEdit->SetValidator(new TIntValidator(10,2,-10,300));
  UintEdit->SetValidator(new TUintValidator(10,2,0,255)); // Almost byte!
  // Two decimals float
  FloatEdit->SetValidator(new TFloat2Validator(10,2));
  // General science format double
  DoubleEdit->SetValidator(new TDScienceValidator(10,3,0.,1.e100));

  // The radiobuttons in a groupbox. Assumes sequence of button ID's!
  new TRadioGroupBox(this,IDC_GROUP,IDC_RADIOBUTTON1, IDC_RADIOBUTTON3);
  SetTransferBuffer(&NumT);
}

void TNumValDialog::ShowTransfer()
{
  // Called when Transfer button is pressed
  // Request transfer and display a message box with results
  char Result[255];
  TransferData(tdGetData);
  ostrstream(Result,254) <<
    "Int="       << NumT.TheInt <<
    ";  UINT="   << NumT.TheUint <<
    ";  float="  << NumT.TheFloat <<
    ";  double=" << NumT.TheDouble <<
    "\n RadioID="<< NumT.TheRadio <<
    "("          << (NumT.TheRadio - IDC_RADIOBUTTON1+1)<<
    ")"          << ends;
  MessageBox(Result,"Numval",MB_OK);
}

class TNumValApp: public TApplication
{
  public:
    TNumValApp(): TApplication("NumVal Test"){EnableCtl3d();}
    void InitMainWindow()
    {
      NumT.TheFloat=333.1233; // Preset a few numbers
      NumT.TheDouble=1.3e14;
      SetMainWindow (new TFrameWindow(0,"NumVal Test",
                     new TNumValDialog(), TRUE));
    }
};

int OwlMain(int , char**){ return TNumValApp().Run();}

