/***********************************************************/
/*	Program: NB_API.C				   */
/*       Author: Greg Layton				   */
/*     Revision: 01.01.00				   */
/*         Date: 06/20/91				   */
/***********************************************************/

#include "nb_api.h"

struct NCB add_name(char *name)
{
	struct NCB tmp;

	memset(&tmp,'\0',sizeof(struct NCB));
	tmp.NCB_COMMAND=ADD_NAME;
	strncpy(tmp.NCB_NAME,name,16);
	tmp=nb_request(tmp);
	return(tmp);
	/* Need to pull NCB_NUM as Local Name Number */
}

struct NCB del_name(char *name)
{
	struct NCB tmp;

	memset(&tmp,'\0',sizeof(struct NCB));
	tmp.NCB_COMMAND=DELETE_NAME;
	strncpy(tmp.NCB_NAME,name,16);
	tmp=nb_request(tmp);
	return(tmp);

}

struct NCB nb_request(struct NCB tmp)
{
	tmp.NCB_LANA_NUM=0;
	_ES=FP_SEG(&tmp);
	_BX=FP_OFF(&tmp);
	_AX=0x100;
	geninterrupt(0x5C);
	return(tmp);
}

struct NCB call(char *rem_name, char *loc_name, unsigned timeout)
{
	struct NCB tmp;

	memset(&tmp,'\0',sizeof(struct NCB));
	tmp.NCB_COMMAND=CALL_WAIT;
	strncpy(tmp.NCB_CALLNAME,rem_name,16);
	strncpy(tmp.NCB_NAME,loc_name,16);
	tmp.NCB_RTO=(timeout*2);
	tmp.NCB_STO=(timeout*2);
	tmp=nb_request(tmp);
	return(tmp);
	/* Need to pull NCB_LSN for Session LSN */
}

struct NCB listen(char *rem_name, char *loc_name, unsigned timeout)
{
	struct NCB tmp;

	memset(&tmp,'\0',sizeof(struct NCB));
	tmp.NCB_COMMAND=LISTEN_WAIT;
	strncpy(tmp.NCB_CALLNAME,rem_name,16);
	strncpy(tmp.NCB_NAME,loc_name,16);
	tmp.NCB_RTO=(timeout*2);
	tmp.NCB_STO=(timeout*2);
	tmp=nb_request(tmp);
	return(tmp);
	/* Need to pull NCB_LSN for Target LSN */
}

struct NCB hang_up(unsigned char target_lsn)
{
	struct NCB tmp;

	memset(&tmp,'\0',sizeof(struct NCB));
	tmp.NCB_COMMAND=HANG_UP_WAIT;
	tmp.NCB_LSN=target_lsn;
	tmp=nb_request(tmp);
	return(tmp);
}

struct NCB send(char *buffer, unsigned int length, unsigned char session_lsn)
{
	struct NCB tmp;

	memset(&tmp,'\0',sizeof(struct NCB));
	tmp.NCB_COMMAND=SEND_WAIT;
	tmp.NCB_LSN=session_lsn;
	tmp.NCB_BUFFER_SEGMENT=FP_SEG(buffer);
	tmp.NCB_BUFFER_OFFSET=FP_OFF(buffer);
	tmp.NCB_LENGTH=length;
	tmp=nb_request(tmp);
	return(tmp);
}

struct NCB receive(char *buffer, unsigned int length, unsigned char session_lsn)
{
	struct NCB tmp;

	memset(&tmp,'\0',sizeof(struct NCB));
	tmp.NCB_COMMAND=RECEIVE_WAIT;
	tmp.NCB_LSN=session_lsn;
	tmp.NCB_BUFFER_SEGMENT=FP_SEG(buffer);
	tmp.NCB_BUFFER_OFFSET=FP_OFF(buffer);
	tmp.NCB_LENGTH=length;
	tmp=nb_request(tmp);
	return(tmp);
}

int check_nb_install(void)
{
	_AX=0;
	geninterrupt(0x2A);
	return(_AH);
}

void print_ncb(struct NCB ncb)
{
	printf("\r\nCommand: %02Xh\r\n",ncb.NCB_COMMAND);
	printf("Return Code: %02Xh\r\n",ncb.NCB_RETCODE);
	printf("LSN: %02Xh\r\n",ncb.NCB_LSN);
	printf("Local Name Number: %02Xh\r\n",ncb.NCB_NUM);
	printf("Buffer Address: %04Xh:%04Xh\r\n",ncb.NCB_BUFFER_SEGMENT,
	ncb.NCB_BUFFER_OFFSET);
	printf("Buffer Length: %u\r\n",ncb.NCB_LENGTH);
	printf("Call Name: %s\r\n",ncb.NCB_CALLNAME);
	printf("Local Name: %s\r\n",ncb.NCB_NAME);
	printf("RX Timeout: %d\r\n",ncb.NCB_RTO);
	printf("TX Timeout: %d\r\n",ncb.NCB_STO);
	printf("Post Routine: %04Xh:%04Xh\r\n",ncb.NCB_POST_SEGMENT,
	ncb.NCB_POST_OFFSET);
	printf("LANA Number: %02Xh\r\n",ncb.NCB_LANA_NUM);
	printf("Command Completion: %02Xh\r\n",ncb.NCB_CMD_CPLT);

}
