/********************************************/
/*                                          */
/*    Name:NBHOST.C                         */
/*                                          */
/*    Purpose: Transmits a File to or       */
/*    	       from a Netbios Partner	    */
/*                                          */
/*    Revision: 01.00.00                    */
/*        Date: 06/08/91                    */
/*                                          */
/********************************************/

/* Include Statements */
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <alloc.h>
#include <dos.h>
#include <dir.h>
#include <string.h>
#include "nb_api.c"

/* Global Variables */
unsigned int length;
int ret,mode;
unsigned char loc_name_num,session_lsn;
char *buffer,*loc_name,*rem_name,temp[20],temp1[20];

/* Global Structures */
struct NCB ncb;
struct MSG message;
#define MAX_BUFF	63000

/* Function Definitions */
void create_window(int left, int top, int right, int bottom, int color);
void start_session(void);
void get_cmd(void);
void dos_cmd(char *);
void tx_file(char *);
void rx_file(char *);
void clean_up(void);

void main(void)
{

	/* Allocate Memory for Buffer */
	buffer=(char *)farcalloc(MAX_BUFF+10,sizeof(char));
	if(buffer==NULL){
		printf("ERROR: Unable to allocate main buffer!\r\n");
		exit(-1);
		};
	loc_name=(char *)farcalloc(16,sizeof(char));
	rem_name=(char *)farcalloc(16,sizeof(char));
	if(rem_name==NULL){
		printf("ERROR: Unable to allocate name buffers!\r\n");
		clean_up();
		};
	clrscr();
	textcolor(WHITE);
	 /* create_window(20,6,60,16,BLUE); */
	cprintf("\r\n\r\n          Netbios HOST Utility\r\n");
	cprintf("     Dawn Development Corp.   1991\r\n\r\n");
	start_session();
	while(!kbhit()){
		printf("\r\nWaiting for CLIENT Command...\r\n");
		get_cmd();
		};
	clean_up();

}

void create_window(int left, int top, int right, int bottom, int color)
{
	textbackground(color);
	window(left,top,right,bottom);
	clrscr();
	/* Make Border */

	window(left+1,top+1,right-1,bottom-1);
}

void start_session(void)
{
	/***************** START SESSION ************************/
	cprintf("Enter Host Name: ");
	temp[0]=15;
	loc_name=cgets(temp);
	cprintf("\r\nAdding HOST Name to Table\r\n");
	ret=check_nb_install();
	if(ret==0){
		cprintf("\r\nERROR: Netbios NOT Installed..\r\n");
		exit(-2);
		};
	/*********** Add Local Name and Call Remote *************/
	ncb=add_name(loc_name);
	if(ncb.NCB_RETCODE!=0){
		cprintf("ERROR: Unable to ADD Local Name!\r\n");
		cprintf("ERROR: %Xh\r\n",ncb.NCB_RETCODE);
		clean_up();
		};
	loc_name_num=ncb.NCB_NUM;
	cprintf("Enter Client Name: ");
	temp1[0]=15;
	rem_name=cgets(temp1);
	cprintf("\r\nListening for %s\r\n",rem_name);
	ncb=listen(rem_name,loc_name,0);
	if(ncb.NCB_RETCODE!=0){
		cprintf("\r\nERROR: Unable to LISTEN for client!\r\n");
		cprintf("ERROR: %Xh\r\n",ncb.NCB_RETCODE);
		clean_up();
		};
	session_lsn=ncb.NCB_LSN;
	cprintf("Session Established...%02Xh\r\n",session_lsn);
}

void get_cmd(void)
{
	ncb=receive((char *)&message,sizeof(struct MSG),session_lsn);
	if(ncb.NCB_RETCODE==0x0A || ncb.NCB_RETCODE==0x05){
		printf("\r\nSession Terminated by Client...\r\n");
		printf("Listening for %s\r\n",rem_name);
		ncb=listen(rem_name,loc_name,0);
		if(ncb.NCB_RETCODE!=0){
			cprintf("\r\nERROR: Unable to LISTEN for client!\r\n");
			cprintf("ERROR: %Xh\r\n",ncb.NCB_RETCODE);
			clean_up();
			};
		session_lsn=ncb.NCB_LSN;
		cprintf("Session Established...%02Xh\r\n",session_lsn);
		return;
		};
	if(ncb.NCB_RETCODE!=0){
		printf("ERROR: Receive Command Failed!\r\n");
		printf("ERROR: %02Xh\r\n",ncb.NCB_RETCODE);
		clean_up();
		};
	if((strcmp(message.cmd,"DOSCMD"))==0){
		dos_cmd(message.text);
		};
	if((strcmp(message.cmd,"TXFILE"))==0){
		tx_file(message.text);
		};
	if((strcmp(message.cmd,"RXFILE"))==0){
		rx_file(message.text);
		};
	if((strcmp(message.cmd,"QUIT"))==0){
		clean_up();
		};
	printf("\r\nUnknown Message Received\r\n");
	printf("COMMAND: %s\r\n",message.cmd);
	printf("TEXT: %s\r\n",message.text);

}

void dos_cmd(char *text)
{
	printf("\r\nExecuting: %s\r\n",text);
	ret=system(text);
	memset(&message,'\0',sizeof(struct MSG));
	strcpy(message.cmd,"STATUS");
	if(ret==0){
		strcpy(message.text,"Command Succeeded!");
		}
	else{
		strcpy(message.text,"Command Failed!");
		};
	ncb=send((char *)&message,sizeof(struct MSG),session_lsn);
	if(ncb.NCB_RETCODE!=0){
		cprintf("ERROR: Send Failed!\r\n");
		cprintf("ERROR: %02Xh\r\n",ncb.NCB_RETCODE);
		clean_up();
		};
}

void tx_file(char *text)
{

}

void rx_file(char *text)
{
	/** Client will receive file ****/

	FILE *fl;
	int ret;
	unsigned count;
	unsigned long len;

	fl=fopen(text,"rb");
	if(fl==NULL){
		printf("Unable to OPEN file...\r\n");
		clean_up();
		};
	printf("\r\nSending File: %s\r\n",text);
	/* Start Sending File to Client */
	count=0;
	while(!feof(fl)){
		ret=fread(&buffer,1,MAX_BUFF,fl);
		ncb=send(buffer,ret,session_lsn);
		if(ncb.NCB_RETCODE!=0){
			cprintf("ERROR: Send Failed!\r\n");
			cprintf("ERROR: %02Xh\r\n",ncb.NCB_RETCODE);
			clean_up();
			};
		count+=ret;
		printf("\rSent %7u bytes...",count);
		};

	fclose(fl);

}

void clean_up(void)
{
	/** Checked to see if session has been terminated **/
	while(ncb.NCB_RETCODE!=0x0A){
		ncb=send((char *)&message,sizeof(struct MSG),session_lsn);
		};
	printf("Removing Local Name from Table...\r\n");
	ncb=del_name(loc_name);
	if(ncb.NCB_RETCODE!=0){
		cprintf("ERROR: Delete Name Failed!\r\n");
		cprintf("ERROR: %02Xh\r\n",ncb.NCB_RETCODE);
		exit(-1);
		};
	fcloseall();
	exit(0);
}