//
//  MSGLINE.CPP
//
//      A simple view to display status line messages
//

#define Uses_TProgram
#include <tv.h>

#include "msgline.h"
#include <string.h>

#define cpMessageLine "\x02\x04"   // black/red on white
static MessageLine *ml = 0;

MessageLine::MessageLine( const TRect& r, char *s )
	: TView( r )
{
	strcpy( text, s );
}

TPalette& MessageLine::getPalette() const
{
  static TPalette palette( cpMessageLine, sizeof(cpMessageLine)-1 );
  return palette;
}

void MessageLine::setText( char *s )
{
  strcpy( text, s );
  drawView();
}

void MessageLine::draw()
{
  TDrawBuffer b;
  ushort color = getColor( 0x0201 );
  b.moveChar( 0, ' ', color, size.x );

  b.moveCStr( 1, text, color );
  writeLine( 0, 0, size.x, 1, b );
}

//
//  Used internally to create and insert MessageLine object
//
void InsertStatusLine( char *msg )
{
	TRect r = TProgram::application->getExtent();
	r.a.y = r.b.y-1;
	ml = new MessageLine( r, msg );
	TProgram::application->insert( ml );
}

//
//  First call creates a MessageLine object; 
//  subsequent calls update it
//
void ShowStatusLine( char *msg )
{
	if( ml )
		ml->setText( msg );
	else
		InsertStatusLine( msg );
}

//
//  Destroys the MessageLine object, restoring what's underneath
//
void ClearStatusLine()
{
	if( ml )
	{
		TObject::destroy( ml );
		ml = 0;
	}
}


