/*

	MIDINAME.C - Build name of a midi command (for debug purposes)

*/
#include <stdio.h>
#include <stdlib.h>
#include "std.h"
#include "midiname.h"

char *NoteName(int note) {
	int octave;
	char *names[] = {
		"C","C#","D","D#","E","F","F#","G","G#","A","A#","B"
	};
	static char buffer[10];

	octave = note /12;
	note = note % 12;
	sprintf(buffer,"%s-%d",names[note],octave);
	return buffer;
}

#ifdef DOC

DESCRIPTION

Returns a printable name for the supplied midi command. Sysex messages
are not really analyzed.
#endif

char *MidiName(BYTE *midi_cmd) {
	int bank;
	int cmd;
	int channel;
	static char name[80];

	cmd = midi_cmd[0];
	bank = cmd >> 4;
	channel = (cmd & 0x0F)+1;

	switch (bank) {
	case 0x9:
		sprintf(name,"Ch %2d: Note on (%s), velocity = %d)",
					channel, NoteName(midi_cmd[1]),midi_cmd[2]
					);
		return name;
	case 0x8:
		sprintf(name,"Ch %2d: Note off (%s)",
					channel, NoteName(midi_cmd[1])
					);
		return name;
	case 0xA:
		return "Unknown";
	case 0xB:
		switch (midi_cmd[1]) {
		case 1:
			sprintf(name,"Ch %2d: Pitch modulation = %d",
					channel,midi_cmd[2]-64);
			 return name;
		case 2:
			sprintf(name,"Ch %2d: VDF modulation = %d",
					channel,midi_cmd[2]-64);
			 return name;
		case 6:
			sprintf(name,"Ch %2d: Data entry MSB = %d",
					channel,midi_cmd[2]);
			return name;
		case 7:
			sprintf(name,"Ch %2d: Volume = %d",
					channel,midi_cmd[2]);
			return name;
		case 0x26:
			sprintf(name,"Ch %2d: Data entry LSB = %d",
					channel,midi_cmd[2]);
			return name;
		case 0x40:
			if (midi_cmd[2] >= 64) {
				sprintf(name,"Ch %2d: Damper on",channel);
				return name;
			}
			sprintf(name,"Ch %2d: Damper off",channel);
			return name;
		case 0x60:
			sprintf(name,"Ch %2d: Data increment",channel);
			return name;
		case 0x61:
			sprintf(name,"Ch %2d: Data decrement",channel);
			return name;
		case 0x7A:
			sprintf(name,"Ch %2d: Local control %s",channel,midi_cmd[2] == 0 ? "off":"on");
			return name;
		case 0x7B:
		case 0x7C:
		case 0x7D:
		case 0x7E:
		case 0x7F:
			sprintf(name,"Ch %d: All notes off",channel);
			return name;
		default:
			sprintf(name,"Ch %2d: Control %d = %d",
				midi_cmd[1],midi_cmd[2]);
			return name;
		}
	case 0xC:
		sprintf(name,"Ch %2d: Program/Combi = %d",
					channel,midi_cmd[1]
		);
		return name;
	case 0xD:
		sprintf(name,"Ch %2d: After touch = %d",
					channel,midi_cmd[1]
		);
		return name;
	case 0x0E:
		sprintf(name,"Ch %2d: Bender = %d",
			channel,midi_cmd[1]
			);
		return name;
	case 0x0F:
		switch (midi_cmd[0] & 0x0F) {
		case 0x02:
			sprintf(name,"Common: Song position = %ld",
					((long) midi_cmd[1] << 7) +midi_cmd[2]
				);
			return name;
		case 0x03:
			sprintf(name,"Common: Song = %d",
					midi_cmd[1]
			);
			return name;
		case 0x08:
			return "Common: Timing clock";
		case 0x0A:
			return "Common: Start";
		case 0x0B:
			return "Common: Stop";
		case 0x0C:
			return "Common: Active sensing";
		case 0x00:
			return "Common: System exclusive";
		}
	}
	return "Unkown command";
}