                           MP -- Modify Path

USAGE

	MP [-{p|a} newpathnode | -r oldpathnode [newpathnode] ]*


FUNCTION

	MP modifies the working path for MS DOS environments by
prepending ("-p") or appending ("-a") a new path node to an existing path
environment or by replacing ("-r") an old path node ("oldpathnode") with
a new path node ("newpathnode") within the existing path.  For the -r
option, the field specifying "newpathnode" can be empty, thus deleting
"oldpathnode" from the search path entirely.

	Note that for the -r switch, the new path node that might replace 
the old path node in the PATH list may be omitted: if so, the old path node
is removed from the PATH list but is not replaced.  Since switches are 
processed in the order entered, a -r followed by a -p or -a can be used
to move a node from the interior of a PATH list to the beginning or end
of that list.

	The path node names are case sensitive!  

	This program operates on the PARENT process environment, thus
eliminating the requirement to use a batch file or enter a complete new
path specification to make minor modifications to the working path.


IMPLEMENTATION

	MP copies the environment block from the parent process to local
strings, modifies the local string for PATH, then copies the complete
set of environment strings back to the parent environment block.


ERROR CONDITIONS

	MP will report an error and leave the path unmodified if there
is insufficient room in the environment block for the modified PATH
environment variable.  In this situation, the path could not be
modified even at the command level.  To prepare for future use of MP or
changes to the path by other methods in this case, increase the size of
the environment block by modifying the CONFIG.SYS file line specifying 

	COMSPEC=dd:COMMAND.COM/e:nnn

to increase (or specify) the /e: parameter for the size of the
environment block.

	MP also reports if a switch is given with no nodename to process, if 
an invalid switch is given, or if switches are not prefixed with '-'.


LANGUAGE AND COMPATIBILITY

	MP is written in TURBOC and has been tested with DOS 3.3, DOS
4.01, and DOS 5.0.  Since it does not use DOS systems calls to effect
the modifications (and cannot, since DOS does not provide a mechanism
for a child process to change the environment block of its parent), MP
may be incompatible with future versions of DOS.


AUTHOR

	MP was written by H. D. Todd, Wesleyan University, December,
1990 and is supplied in source-code form.  The author would appreciate
receiving bug reports and modifications (send to
HDTodd@eagle.wesleyan.edu or HDTodd@wesleyan.bitnet).
