#if !defined(__montrapp_h)              // Sentry, use file only if it's not already included.
#define __montrapp_h

/*  Project monitor
    
    Copyright  1994. All Rights Reserved.

    SUBSYSTEM:    monitor.exe Application
    FILE:         montrapp.h
    AUTHOR:       Philippe Goutier


    OVERVIEW
    ========
    Class definition for monitorApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include <owl\controlb.h>
#include <owl\buttonga.h>
#include <owl\editfile.h>
#include <owl\opensave.h>

#include "montrapp.rh"            // Definition of all resources.


//
// FrameWindow must be derived to override Paint for Preview and Print.
//
//{{TDecoratedFrame = SDIDecFrame}}
class SDIDecFrame : public TDecoratedFrame {
public:
    SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, BOOL trackMenuSelection = FALSE, TModule *module = 0);
    ~SDIDecFrame ();

//{{SDIDecFrameVIRTUAL_BEGIN}}
public:
    virtual void SetupWindow ();
//{{SDIDecFrameVIRTUAL_END}}
};    //{{SDIDecFrame}}


//{{TApplication = monitorApp}}
class monitorApp : public TApplication {
private:
    TOpenSaveDialog::TData FileData;                    // Data to control open/saveas standard dialog.

private:
    void SetupSpeedBar (TDecoratedFrame *frame);

public:
    monitorApp ();
    virtual ~monitorApp ();

    void OpenFile (const char *fileName = 0);
//{{monitorAppVIRTUAL_BEGIN}}
public:
    virtual void InitMainWindow();
//{{monitorAppVIRTUAL_END}}

//{{monitorAppRSP_TBL_BEGIN}}
protected:
    void CmFileNew ();
    void CmFileOpen ();
    void CmFileClose ();
    void CmHelpAbout ();
//{{monitorAppRSP_TBL_END}}
  DECLARE_RESPONSE_TABLE(monitorApp);
};    //{{monitorApp}}


#endif                                      // __montrapp_h sentry.
