#include <string.h>
#include <windows.h>

/* -------------------------------------------------------------------------- */

char* interMem;
const int MaxSize = 10000;

/* -------------------------------------------------------------------------- */

void* CreateFileMap(const char *name,	unsigned long size)
{
	void *handle = CreateFileMapping((HANDLE)0xFFFFFFFF, NULL, PAGE_READWRITE, 0, size, name);
	if (handle)
	{
		void *p = MapViewOfFile(handle, FILE_MAP_READ | FILE_MAP_WRITE, 0, 0, 0);
		if (p)
			return p;
		else
			CloseHandle(handle);
	}
	return NULL;
}

/* -------------------------------------------------------------------------- */

void _export RegisterDebugMonitor()
{
	if (! interMem)
		interMem = (char *)CreateFileMap("DebugMonitor", MaxSize);
	if (interMem)
		*interMem = 0;
}

/* -------------------------------------------------------------------------- */

void _export DisplayDebugString(const char *s, int cr)
{
	static unsigned int size;

	if (! interMem)
		interMem = (char *)CreateFileMap("DebugMonitor", MaxSize);

	if (interMem)
	{
		HANDLE handle = OpenMutex(MUTEX_ALL_ACCESS, 0, "ReadingInfo");
		if (handle)
		{
			WaitForSingleObject(handle,INFINITE);
			CloseHandle(handle);
		}

		if (*interMem == 0) // Display process has cleared buffer
			size = 0;
		int len = strlen(s);
		if ((size + len + 3) < MaxSize)	// enough room to store new string?
		{
			handle = CreateMutex(NULL, 1, "WritingInfo");

			strcat(interMem, s);
			size += len;
			if (cr)
			{
				strcat(interMem, "\r\n");
				size += 2;
			}

			ReleaseMutex(handle);
			CloseHandle(handle);
		}
	}
}

/* -------------------------------------------------------------------------- */

void _export DisplayDebugInt(int v, int cr)
{
	char buf[100];
	wsprintf(buf, "%i", v);
	DisplayDebugString(buf, cr);
}

/* -------------------------------------------------------------------------- */

char* _export GetInterMem()
{
	if (! interMem)
		RegisterDebugMonitor();
	return interMem;
}

/* -------------------------------------------------------------------------- */


