/*  Project test
    Caprock Software
    Copyright  1995. Caprock Software. All Rights Reserved.

    SUBSYSTEM:    test.exe Application
    FILE:         tsttdlgc.cpp
    AUTHOR:       Scott Stubbs


    OVERVIEW
    ========
    Source file for implementation of testTDLGClient (TDialog).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include "testapp.h"
#include "tsttdlgc.h"


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(testTDLGClient, TDialog)
//{{testTDLGClientRSP_TBL_BEGIN}}
    EV_WM_ERASEBKGND,
    EV_WM_DESTROY,
    EV_WM_TIMER,
//{{testTDLGClientRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{testTDLGClient Implementation}}


//////////////////////////////////////////////////////////
// testTDLGClient
// ==========
// Construction/Destruction handling.
testTDLGClient::testTDLGClient (TWindow *parent, TResId resId, TModule *module)
    : TDialog(parent, resId, module)
{
	mbar1 = new TVbxControl(this, IDC_METERBAR1);
	mbar2 = new TVbxControl(this, IDC_METERBAR2);
	mbar3 = new TVbxControl(this, IDC_METERBAR3);
	mbar4 = new TVbxControl(this, IDC_METERBAR4);
}


testTDLGClient::~testTDLGClient ()
{
    Destroy();

	delete mbar1;
	delete mbar2;
	delete mbar3;
    delete mbar4;
}

bool testTDLGClient::EvEraseBkgnd (HDC dc)
{
    bool result;

	result = TDialog::EvEraseBkgnd(dc);

	TDC myDC(dc);
	TBrush brush(::GetSysColor(COLOR_BTNFACE));
	TRect rect = GetClientRect();
	myDC.FillRect(rect, brush);

	return result;
}

bool testTDLGClient::EvInitDialog (HWND hWndFocus)
{
	bool result;

	result = TDialog::EvInitDialog(hWndFocus);

	SetTimer(1, 150);

	return result;
}

void testTDLGClient::EvDestroy ()
{
    TDialog::EvDestroy();

	KillTimer(1);
}


void testTDLGClient::EvTimer (uint)
{
    int pos, ran;

	mbar1->GetProp("Range", ran);
	mbar1->GetProp("Position", pos);
	pos++;
	if (pos > ran)
	   pos = 0;
	mbar1->SetProp("Position", pos);

	mbar2->GetProp("Range", ran);
	mbar2->GetProp("Position", pos);
	pos++;
	if (pos > ran)
	   pos = 0;
	mbar2->SetProp("Position", pos);

	mbar3->GetProp("Range", ran);
	mbar3->GetProp("Position", pos);
	pos++;
	if (pos > ran)
	   pos = 0;
	mbar3->SetProp("Position", pos);

	mbar4->GetProp("Range", ran);
	mbar4->GetProp("Position", pos);
	pos++;
	if (pos > ran)
	   pos = 0;
	mbar4->SetProp("Position", pos);
}


