SUPLDIR = ..\suplment
EXTRADIR = ..\extras

CC = wcc386
CFLAGS = /zq /i=..\include

LINK = wlink
LFLAGS = system dos4g option stack=8192

ZSVGAOBJS = $(SUPLDIR)\main.obj &
            $(SUPLDIR)\zwhvesa.obj &
            $(SUPLDIR)\zgetzero.obj

ZSVGALIBS = ..\lib\zsvga.lib

EXES      = maskline.exe

all: $(EXES)


# COMMON MODULES

$(SUPLDIR)\main.obj: $(SUPLDIR)\main.c
	$(CC) $(CFLAGS) /fo$*.obj $?

$(SUPLDIR)\zwhvesa.obj: $(SUPLDIR)\zwhvesa.c
	$(CC) $(CFLAGS) /fo$*.obj $?

$(SUPLDIR)\zgetzero.obj: $(SUPLDIR)\zgetzero.c
	$(CC) $(CFLAGS) /fo$*.obj $?

# INDIVIDUAL EXAMPLES

maskline.exe:  maskline.c $(ZSVGAOBJS)
    $(CC) $(CFLAGS) $[@
    @@echo NAME $^@ >$(EXTRADIR).lnk
    @@echo FILE $[*.obj >>$(EXTRADIR).lnk
    @for %i in ($(ZSVGAOBJS)) do @@echo FILE %i >>$(EXTRADIR).lnk
    @for %i in ($(ZSVGALIBS)) do @@echo FILE %i >>$(EXTRADIR).lnk
    $(LINK) $(LFLAGS) @$(EXTRADIR).lnk
    @del $(EXTRADIR).lnk
    @del $*.obj
