/* $Header$ */

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>

/* 
the port address of the lpt ports is stored starting at 0000:0408 
the following lines finds the address of lpt1 :

unsigned pPort;
    pPort = * ( (unsigned far * ) 0x408 );
for this program, however, we will hardcode LPT address to 0x378
*/
unsigned pData = 0x378;
unsigned pCntrl = 0x37a;
int valData;	/* memory copy of value last set in this register */
int valCntrl;	/* memory copy of value last set in this register */    

/* return 0 on success */
int parse( char * str, int * pTarget, int * pAction, int * pValue )
{
int i;
    
    /* check len */
    i = strlen( str );
    if ( 3 > i )
	{
	printf( "strlen = %d\n", i );
	return( 1 );
	}
	
    /* pTarget */
    i = tolower( str[0] );
    if ( ( i=='d' ) || ( i=='c' ) )
	* pTarget = i;
    else
	return( 2 );
	
    /* pAction */
    i = tolower( str[1] );
    if ( ( i=='s' ) || ( i=='c' ) || ( i=='t' ) || ( i=='w' ) )
	* pAction = i;
    else
	return( 3 );
	
    /* pValue */
    sscanf( str+2, "%2x", pValue );
    
    return( 0 );
}


void doit( int target, int action, int value )
{
unsigned * ppReg;
int * ppVal;
    
    switch( target )
	{
	case 'd' :
	    ppReg = & pData;
	    ppVal = & valData;
	    break;
	    
	case 'c' :
	    ppReg = & pCntrl;
	    ppVal = & valCntrl;
	    break;
	    
	default :
	    return;
	}
    
    switch( action )
	{
	case 'w' :
	    * ppVal = value;
	    break;
	    
	case 's' :
	    * ppVal |= value;
	    break;
	    
	case 'c' :
	    * ppVal &= (~value);
	    break;
	    
	case 't' :
	    * ppVal ^= value;
	    break;
	    
	default :
	    return;
	}
	
    /* now set register */
    outp( *ppReg, *ppVal );
}

int main()
{
char str[255];
int target;	/* 'd'=data 'c'=cntrl */
int action;	/* 's'=set  'c'=clear 't'=toggle */
int value;	/* 8 bit */
int err;

    /* init memory copies */
    valData = inp( pData );
    valCntrl = inp( pCntrl );

    printf("\n\ncommand syntax :\n\n");
    printf("\t\t1st char = d(ata) or c(ntrl)\n");
    printf("\t\t2nd char = w(rite), s(et), c(lear), or t(oggle)\n");
    printf("\t\t3&4 chars = two digit hex value\n\n");

    while(1)
	{
	gets( str );
	
	/* exit ? */
	if ( 'q' == tolower( str[0] ) )
	    return( 0 );
	    
	if ( err = parse( str, &target, &action, &value ) )
	    printf("\tinvalid entry : %d : %s\n", err, str);
	else
	    doit( target, action, value );
	}
}

