//	PROGRAM:	LINECNT.CPP
//	AUTHOR:		allen wayne best, esq.
//	DATE:		9 December 1990, ad
//	COMPUSERVE:	72701,1350
//	ADDRESS:    Atoka Software
//				218 Killingsworth
//				Camden, AR 71701
//
// This program is developed by allen wayne best, esq. It is not to be used
// for any commercial purposes. It shall remain the property of the author.
// if the user improves on the program in any way, (s)he is requested to give
// a copy of the source code with all changes to the author, allen wayne best,
// esq. this program and any variants may be distributed so long as this banner
// and the copyright remain part of the program.

#include <iostream.h>
#include <fstream.h>

#include <dir.h>
#include <sys\stat.h>
#include <errno.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <io.h>

const	int 	TRUE=-1;
const	int 	FALSE=0;
const	int		MAX_READ=255;
const	int		Page_Lines=86;

main(int argc, char *argv[])
{
	struct	ftime filetime;

	FILE	*read_stream;

	char 	headline[133],			// file name whose lines were counted
			file_date[133],
			pline[MAX_READ+7],
			instring[MAX_READ],		// string input
			dummy,
			*p,
			*p2;

	char	*banner="Page = ";
	char	*Compress="\xf\x1b\x30";
	char	fFeed='\xc';

	char	infile[MAXPATH]="",
			path[MAXPATH],
			drive[MAXDRIVE],
			directory[MAXDIR],
			filename[MAXFILE],
			ext[MAXEXT];

	char	path2[MAXPATH],
			path3[MAXPATH],
			drive2[MAXDRIVE]="",
			directory2[MAXDIR]="",
			filename2[MAXFILE],
			ext2[MAXEXT];

	char 	*copyright={"LINECNT (c) 1.00 Atoka Software 1989, 1990. by Allen Wayne Best, esq.\n"
			"\t(Produced in cooperation with the Department of Localised Weirdities,\n"
			"\t Unified Singularities Division.)\n\n"
			"\tThis program is copyrighted and shall not be used in part or in\n"
			"\twhole for any commercial purpose, except by the express permission\n"
			"\tof the author. All modifications must retain this copyright and be\n"
			"\tsubmitted to the author.\n"};

	char	*instruct={	"LINECNT [-s -d -h -c] [d:][\\path\\]filename.ext\n"
						"\twhere the switches are\n"
						"\t\t-s the output will be put into a single file with the extension\n"
						"\t\tof .LN1\n\n"
						"\t\t-d the output will be put into two files, .LN1 and .LN2.\n\n"
						"\t\t-h help\n\n"
						"\t\t-c put output to current disk/directory.\n\n"
						"\tThe filename.ext is assumed to be in the current directory and disk\n"
						"\tunless the disk and/or path is explicitly given. The output file(s)\n"
						"\twill be place on the same disk and path as the source file, UNLESS the\n"
						"\t-c switch is used. The -c switch causes the output file(s) to be placed\n"
						"*** Press any key to continue ***" };

	char	*more_instruct={"\n\tin the current directory and disk.\n\n"
						"\tThe -d switch (the default) causes the output to be placed in two files,\n"
						"\tfilename.LN1 and filename.LN2. These two files contain the output in\n"
						"\talternating page form. That is, all of the odd pages are in .LN1 and\n"
						"\tall the even pages are in .LN2. -s causes all pages to be in the one\n"
						"\tfile, filename.LN1.\n\n" };

	long	line_count=0L;			// number of lines of code in file

	int		status,					// status of function return
			ostat,
			index,
			page=1,
			eol=FALSE,				// flag end of line
			new_page=FALSE,			// flag TRUE if need to go to new page
			lines=2,
			front=TRUE,				// TRUE if odd page number, FALSE if even
			dside=TRUE,				// TRUE if two output files
			current_path=FALSE,		// TRUE if output to current path
			brace_cnt=0;

	status = 0;

	for (index=1; index < argc && argv[index]; index++)
	{
		if (argv[index][0]=='-' || argv[index][0]=='/')
		{
			switch (argv[index][1])
			{
				case 'd':
				case 'D':	dside=TRUE;	// create two files for double sided printing
							break;
				case 's':
				case 'S':	dside=FALSE;	// create a single file
							break;
				case 'c':
				case 'C':	current_path=TRUE;	// output to current location
							break;
				case 'h':
				case 'H':
				case '?':	cout << copyright;
							cout << instruct;
							cin.get(dummy);
							cout << more_instruct;
							exit(0);
			}
		}
		else
		{
			strcpy(infile, argv[index]);
		}
	}

	if (!infile[0])
	{
		while (status==0)
		{
			printf("Enter name of source code file: ");
			status = scanf("%s",infile);
			if (status==EOF)
			{
				cout << copyright;
				cout << instruct;
				cin.get(dummy);
				cout << more_instruct;
				exit(0);
			}
		}
	}

	strupr(infile);

	status=fnsplit(	infile,
					drive,
					directory,
					filename,
					ext);

	if (!(status & DRIVE))
	{
		drive[0]=getdisk()+'A';
		drive[1]=':';
		drive[2]='\0';
	}

	if (!(status & DIRECTORY))
	{
		getcurdir(0, path);
		strcat(directory,"\\");
		strcat(directory, path);
		strcat(directory,"\\");
	}

	fnmerge(	path,
				drive,
				directory,
				filename,
				ext);

	if (!current_path)
	{
		strcpy(drive2, drive);
		strcpy(directory2, directory);
	}

	strcpy(filename2, filename);

	if (strcmp(ext,".LN1"))
	{
		strcpy(ext2, ".LN1");
	}
	else
	{
		strcpy(ext2, ".LS1");
	}

	fnmerge(	path2,
				drive2,
				directory2,
				filename2,
				ext2);

	if (dside)
	{
		if (strcmp(ext,".LN2"))
		{
			strcpy(ext2, ".LN2");
		}
		else
		{
			strcpy(ext2, ".LS2");
		}

		fnmerge(	path3,
					drive2,
					directory2,
					filename2,
					ext2);
	}

	fstream in(path, ios::in|ios::nocreate);
	if (!in)
	{
		cout << "%%LINECNT-F-File open error, " << sys_errlist[errno] << "\n";
		cout << "\t - file: " << path << "\n";
		exit(errno);
	}

	fstream outfile[2];
	outfile[0].open(path2, ios::out);
	if (!outfile[0])
	{
		cout << "%LINECNT-F-File open error, " << sys_errlist[errno] << "\n";
		cout << "\t - file: " << path2 << "\n";
		exit(errno);
	}

	if (dside)
	{
		outfile[1].open(path3, ios::out);
		if (!outfile[1])
		{
			cout << "%LINECNT-F-File open error, " << sys_errlist[errno] << "\n";
			cout << "\t - file: " << path3 << "\n";
			exit(errno);
		}
	}

	read_stream=fopen(infile, "r+t");
	getftime(fileno(read_stream), &filetime);
	fclose(read_stream);

	switch(filetime.ft_month)
	{
		case 1:		strcpy(headline, "January");
					break;
		case 2:		strcpy(headline, "Febuary");
					break;
		case 3:		strcpy(headline, "March");
					break;
		case 4:		strcpy(headline, "April");
					break;
		case 5:		strcpy(headline, "May");
					break;
		case 6:		strcpy(headline, "June");
					break;
		case 7:		strcpy(headline, "July");
					break;
		case 8:		strcpy(headline, "August");
					break;
		case 9:		strcpy(headline, "September");
					break;
		case 10:	strcpy(headline, "October");
					break;
		case 11:	strcpy(headline, "November");
					break;
		case 12:	strcpy(headline, "December");
					break;
		default:	strcpy(headline, "Unknown");
				break;
	}

	sprintf(file_date, "Date: %02u-%s-%04u        ",
		filetime.ft_day,
		headline,
		filetime.ft_year+1980);

	file_date[27]='\0';	/* force string to be 26 chars long */
	sprintf(headline, "%-27s %-95s % 2u:%02u:%02u\n",
		file_date,
		"\x20",
		filetime.ft_hour,
		filetime.ft_min,
		filetime.ft_tsec/2);

	index=0;

	sprintf(pline,"%s%-80s % 46s %4d\n",
		Compress, path, banner, page);
	outfile[index] << pline;

    errno=0;
	ostat=outfile[index].rdstate();
	if (ostat)
	{
		cout << "LINECNT-E-WRIERR, " << sys_errlist[errno] << "\n";
		exit(errno);
	}

	outfile[index] << headline;
	ostat=outfile[index].rdstate();
	if (ostat)
	{
		cout << "LINECNT-E-WRIERR, " << sys_errlist[errno] << "\n";
		exit(errno);
	}

	in.get(instring, MAX_READ-1, '\n');	// get upto but not including terminator
	status=in.good();		// was this an acceptable read?
	if (in.peek()=='\n')
	{
		eol=TRUE;				// end of line
		in.get(dummy);			// read the terminator
	}

	cout << copyright;

	while (status)
	{
		lines++;
		line_count++;

		p2=p=strstr(instring,"{");	// count braces
		while (p)
		{
			brace_cnt++;
			p2++;
			p=strstr(p2, "{");
		}

		p2=p=strstr(instring,"}");	// count braces
		while (p)
		{
			brace_cnt--;
			p2++;
			p=strstr(p2, "}");
			if (!brace_cnt)
			{
				new_page=TRUE;
			}
		}

		if (lines == Page_Lines)
		{
			if (dside)
			{
				if (front)
				{
					front=FALSE;
					index=1;
				}
				else
				{
					front=TRUE;
					index=0;
				}
			}

			lines = 3;
			page++;

			outfile[index].put(fFeed);
			errno=0;
			ostat=outfile[index].rdstate();
			if (ostat)
			{
				cout << "LINECNT-E-WRIERR, " << sys_errlist[errno] << "\n";
				exit(errno);
			}
			sprintf(pline,"%s%-80s % 46s %4d\n",
				Compress, path, banner, page);
			errno=0;
			outfile[index] << pline;
			ostat=outfile[index].rdstate();
			if (ostat)
			{
				cout << "LINECNT-E-WRIERR, " << sys_errlist[errno] << "\n";
				exit(errno);
			}
			outfile[index] << headline;
			ostat=outfile[index].rdstate();
			if (ostat)
			{
				cout << "LINECNT-E-WRIERR, " << sys_errlist[errno] << "\n";
				exit(errno);
			}
		}

		sprintf(pline,"%6ld %s",line_count, instring);
		errno=0;
		outfile[index] << pline;
		ostat=outfile[index].rdstate();
		if (ostat)
		{
			cout << "LINECNT-E-WRIERR, " << sys_errlist[errno] << "\n";
			exit(errno);
		}

		if (eol)
		{
			errno=0;
			outfile[index] << "\n";
			ostat=outfile[index].rdstate();
			if (ostat)
			{
				cout << "LINECNT-E-WRIERR, " << sys_errlist[errno] << "\n";
				exit(errno);
			}
		}

		in.get(instring, MAX_READ-1, '\n');	// get upto but not including terminator
		status=in.good();		// was this an acceptable read?
		if (in.peek()=='\n')
		{
			eol=TRUE;
			if (new_page)
			{
				lines=Page_Lines-1;	// up line count to force new page after next read..
				new_page=FALSE;
			}
			in.get(dummy);			// read the terminator
		}
		else
		{
			eol=FALSE;
		}
	}

	in.close();
	outfile[0].close();
	if (dside)
	{
		outfile[1].close();
	}

	cout << "Total line count: " << line_count << "\n";
	cout << "Total pages: " << page << "\n";
}
