; LANLIB.INC -- Defines for LANLIB routines
; Copyright (c) 1994 by Allen Brunson  version 1.00  06/30/94


;****************************************************************************
;*                                                                          *
;***  General definitions                                                 ***
;*                                                                          *
;****************************************************************************

FALSE        equ     0                             ;Boolean false
OFF          equ     0                             ; defines
NO           equ     0
TRUE         equ     1                             ;Boolean true
ON           equ     1                             ; defines
YES          equ     1

VECTOR       Struc                                 ;Vector structure
offs         dw      0                             ;Vector offset
segm         dw      0                             ;Vector segment
VECTOR       Ends


;****************************************************************************
;*                                                                          *
;***  Communication size definitions                                      ***
;*                                                                          *
;****************************************************************************

;The following defines are useful in determining how much memory to allocate
;for LANLIB before calling ipxStart().  Each send and receive ECB/buffer
;pair will require IPXCOMMSIZE bytes of memory.  So if you have 8 send
;ECB/buffers and 30 receive ECB/buffers, then the total bytes you would need
;would be (8 + 30) * IPXCOMMSIZE; this formula is given as IPXMEMSIZE.

IPXCOMMSIZE  equ <(size ECB + size IPXPKTHDR + size IPXEVENT + IPXDATASIZE)>

IPXMEMSIZE   equ <((IPXRECVCNT + IPXSENDCNT) * IPXCOMMSIZE)>


;****************************************************************************
;*                                                                          *
;***  LANLIB error return values                                          ***
;*                                                                          *
;****************************************************************************

;These error codes are completely "made up" and bear no relation to the error
;codes that the IPX driver itself returns, which can vary depending on the
;circumstances.  In very rare cases, an error code other than one of the
;following might be returned.  See the documentation for details.

ipxeNOERR            equ      0                    ;No error
ipxeNOIPX            equ      2                    ;IPX driver isn't loaded
ipxeIPXNOTSTARTED    equ      3                    ;ipxStart() not called
ipxeIPXSTARTED       equ      4                    ;ipxStart() already called
ipxeBADCOMMPARMS     equ      5                    ;Bad parms
ipxeMEMTOOSMALL      equ      6                    ;Memory block is too small
ipxeMEMABOVE64K      equ      7                    ;More than 64k mem needed
ipxeNETOVERFLOW      equ      8                    ;Found too many networks
ipxeNOPATHFOUND      equ      9                    ;Can't find this node
ipxeROUTEFINDABORT   equ     10                    ;Route find aborted
ipxeSOCKETTABLEFULL  equ     11                    ;Socket table is full
ipxeSOCKETOPEN       equ     12                    ;Socket already open
ipxeSOCKETNOTOPEN    equ     13                    ;Socket not open
ipxeNOFREESENDECB    equ     14                    ;No free send ECBs
ipxeRECVCANCEL       equ     15                    ;Receive was cancelled
ipxeSENDCANCEL       equ     16                    ;Send was cancelled
ipxeRECVPKTTOOBIG    equ     17                    ;Packet was too big
ipxeSENDPKTBAD       equ     18                    ;Packet was malformed
ipxeSENDBADROUTE     equ     19                    ;Packet was undeliverable
ipxeSENDNETFAIL      equ     20                    ;Hardware or net failure


;****************************************************************************
;*                                                                          *
;***  IPX structure definitions                                           ***
;*                                                                          *
;****************************************************************************

;All word-sized values in the IPX packet header are stored as hi-lo, in
;opposition to standard Intel byte-ordering, which is lo-hi.  Most words in
;the ECB are also hi-lo, with a couple of exceptions.  All addresses in the
;ECB are stored in standard Intel offset-segment format.

IPXADDR      Struc                                 ;IPX address
net          db       4 dup (0)    ;hi-lo          ;Network number
node         db       6 dup (0)    ;hi-lo          ;Node number
socket       dw       0            ;hi-lo          ;Socket number
IPXADDR      Ends

IPXADDRFULL  Struc                                 ;IPX address/route info
net_         db       4 dup (0)    ;hi-lo          ;Network number
node_        db       6 dup (0)    ;hi-lo          ;Node number
socket_      dw       0            ;hi-lo          ;Socket number
immedAddr    db       6 dup (0)    ;hi-lo          ;Immediate address
IPXADDRFULL  Ends

IPXDIAG      Struc                                 ;IPX diagnostic packet
exclCnt      db       0                            ;Exclusion count
exclAddr     db      (42 * 6) dup (0)              ;Exclusion addresses
IPXDIAG      Ends

IPXDIAGREPLY Struc                                 ;Diagnostic reply packet
diagVerMajor db       0                            ;Diagnostic version
diagVerMinor db       0                            ; number
spxDiagSckt  dw       0            ;hi-lo          ;SPX diagnostic socket
components   db       0                            ;Components at this node
component    db      251 dup (0)                   ;Component descriptions
IPXDIAGREPLY Ends

IPXEVENT     Struc                                 ;IPX event structure
eCompCode    dw       0            ;lo-hi          ;Event completion code
ECBptr       dw       0            ;lo-hi          ;Pointer to ECB
IPXEVENT     Ends

IPXPKTHDR    Struc                                 ;IPX packet header
checksum     dw       0            ;hi-lo          ;Packet checksum
length       dw       0            ;hi-lo          ;Packet length
transCtrl    db       0                            ;Transport control
pktType      db       0                            ;Packet type
dst          IPXADDR <>                            ;Destination address
src          IPXADDR <>                            ;Source address
IPXPKTHDR    Ends

ECB          Struc                                 ;Event Control Block
linkAddr     VECTOR  <>            ;off-seg        ;Link address
ESRaddr      VECTOR  <>            ;off-seg        ;ESR address
inUse        db       0                            ;In use flag
compCode     db       0                            ;Completion code
ECBsocket    dw       0            ;hi-lo          ;Socket number
ipxWork      db       4 dup (0)                    ;IPX workspace
driverWork   db      12 dup (0)                    ;Driver workspace
immed        db       6 dup (0)    ;hi-lo          ;Immediate address
fragCnt      dw       0            ;lo-hi          ;Fragment count
pktHdr       VECTOR  <>            ;off-seg        ;IPX packet header address
pktHdrSize   dw       0            ;lo-hi          ;IPX packet header size
pktData      VECTOR  <>            ;off-seg        ;IPX packet data
pktDataSize  dw       0            ;lo-hi          ;IPX packet data size
ECB          Ends


;****************************************************************************
;*                                                                          *
;***  Global data                                                         ***
;*                                                                          *
;****************************************************************************

             Global  ipxRecvMax:word               ;Max receive ECBs in use
             Global  ipxSendMax:word               ;Max send ECBs in use


;****************************************************************************
;*                                                                          *
;***  Function definitions                                                ***
;*                                                                          *
;****************************************************************************

             Global  ipxAddrImmed:Proc             ;Gets immediate address
             Global  ipxAddrLocal:Proc             ;Gets local IPX address
             Global  ipxLibVer:Proc                ;Returns IPX lib version
             Global  ipxRecvChk:Proc               ;Checks for received pkts
             Global  ipxRecvPkt:Proc               ;Gets packet out of queue
             Global  ipxRouteFind:Proc             ;Finds other networks
             Global  ipxSendChk:Proc               ;Checks for send errors
             Global  ipxSendErr:Proc               ;Retrieves send errors
             Global  ipxSendPkt:Proc               ;Sends a data packet
             Global  ipxStart:Proc                 ;Starts up IPX routines
             Global  ipxStop:Proc                  ;Shuts down IPX
