#ifndef JPSTATCS_H
#include <math.h>


// name:    jpstatcs.h --- fast and precise area under some popular
//          statistical distributions calculations header for c/c++
//          programs.  introductory set.
// vers:    V1.04 7/30/95 8/2/95 8/4/95 10/21/95 12/11/95
// author:  john p. pobanz, pe -- ph: (513) 528-6571
// company:	insight engineering co.
// address: 3979-d piccadilly circle, cincinnati, oh  45255-4855
// e-mail:  75132.3577@compuserve.com

// fee:		$15.00 --- when i receive your registration fee, i will e-mail
//				direct to you the full set of distribution functions via
//				compuserve mail so be sure to include your compuserve account
//				number on your check.

// description:
//          these functions are very precise and converge very
//          quickly.  they are not approximations or short-cuts and
//          operate over an extreemly wide range of the variables given.
//          all numbers are double precision and functions were tested
//          under a system using 8 byte numbers.  this header will work
//          for either c or c++ source programs.  minimum precision of
//          resulting area is 10 decimal places, often more.  degrees
//          of freedom, where required, must be positive but need not
//          be whole numbers.  all areas are computed from the very left
//          of the distribution curve up through the statistic. knowing
//          that all probability distributions have a total area of
//          exactly 1, it is a simple matter to get the area to the right
//          of the statistic when required: arearight = (1.0 - arealeft).
//          any questions or comments should be addressed to me.  I can be
//				reached by mail, by phone, or on compuserve (75132,3577).

// user calls:  (* denotes function is included in the registered set)
// 		  *lgamma(x) -- natural log of gamma function of positive x.
//         *lbeta(m, n) -- natural log of beta function of positive (m, n).
//          areaz(z) -- area under standard normal 'bell' curve up to z.
//         *areat(t, df) -- area under student's t distribution up to t.
//         *areaf(f, df_num, df_den) -- area under f distribution up to f.
//         *areax2(x2, df) -- area under chi-square distribution to x2.
//          areaw(x, x0, theta, slope) -- area under weibull distribution.
//          areau(x, a, b) -- area under uniform distribution up to x.
//         *areag(x, o, l) -- area under gamma distribution up to x.
//          areae(x, lambda) -- area under exponential distribution up to x.
//         *areab(x, n, p) -- area under beta distribution up thru x.
//          areabi(x, n, p) -- area under binomial distribution up thru x.


// return the sign of a number.
double _jpsign(double x) {
	if (x > 0.0) return 1.0;
	if (x < 0.0) return -1.0;
	return 0.0; }

// raise a positive real number to a real power.
double _jpraised(double a, double p) {
	return exp(p * log(a)); }

// area under the normal curve accurate to 13 decimal places.
double areaz(double z) {
	double f, u, s, t, twopi, s1;
	u = z * z;
	if (u > 55.5) return ((_jpsign(z) + 1.0) / 2.0);
	twopi = 8.0 * atan(1.0); s = 0.0; t = 1.0; f = 3.0;
	do {s1 = s; s += t; t = t * u / f; f += 2.0;} while (s != s1);
	return (z * s / sqrt(twopi * exp(u)) + 0.5); }

// weibull distribution accurate to 15+ decimal places.
double areaw(double x, double x0, double theta, double slope) {
	if (x <= x0) return 0.0;
	return (1.0 - exp(-_jpraised((x - x0) / (theta - x0), slope))); }

// uniform distribution accurate to 15+ decimal places.
double areau(double x, double a, double b) {
	if (x <= a) return 0.0;
	if (x >= b) return 1.0;
	return ((x - a) / (b - a)); }

// exponential distribution accurate to 15+ decimal places.
double areae(double x, double lambda) {
	if (x <= 0.0) return 0.0;
	return (1.0 - exp(-lambda * x)); }

// binary distribution sub-function.
double _jpareabi1(double x, double n, double p) {
	double a, g, i1, i2, k, l1, l2, q;
	l1 = log(p); l2 = log(1.0 - p);
	a = k = g = i1 = 0.0; i2 = n + 1.0; goto _M150;

_M140:	g += log(i2 / i1);
_M150:	q = g + l1 * k + l2 * (n - k);
	if (q < -227.0) q = -227.0;
	a += exp(q); i2--; i1++; k++;
	if (k <= x) goto _M140;
	return a; }

// binary distribution accurate to 10+ decimal places.
double areabi(double x, double n, double p) {
	if (x > n / 2.0) return (1.0 - _jpareabi1(n - x - 1.0, n, 1.0 - p));
	return _jpareabi1(x, n, p); }

#endif
#define JPSTATCS_H
