/**********************************************************************
**
** SCALE.H
**
** Small program that shows how to scale when the source and
** destination are both under 64K
**
**********************************************************************/

//start of VGA memory
#define VgaMem ((unsigned char *)0xA0000000)

//for writing palette
#define VgaStartColor 0x03c8
#define VgaPort 0x03c9

//for bounding areas
typedef struct
{
   int Sx, Sy, Ex, Ey;
}Rect;

typedef Rect * pRect;

//functions
void SetVideoMode(int Mode);
void LoadJohn(void);
void GetImage(pRect r, unsigned char * Buffer);
void PutImage(pRect r, unsigned char * Buffer);
void PalGrayScale(void);
void Scale(pRect Source, pRect Dest);
unsigned int ImageSize(pRect r);
int GetKey(void);
