//                                               //
// Copyright <c> Borland International, 1993-4   //
//                                               //

/////////////////////////////////////////////////////////////////////////
//  IdeHook can be used to customize and enhance the functionality     //
//  of the Borland C++ Integrated Development Environment 4.0.         //
/////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////
//  FEATURE OVERVIEW:                                                //
///////////////////////////////////////////////////////////////////////
//                                                                         //
//  With IdeHook.h (and the two ccompanying .obj file) users can           //
//  encorporate many powerful features seemlessly into the IDE like        //
//                                                                         //
//      1) installing tools onto the 'Tools' menu                          //
//      2) installing tools onto the SpeedMenu of specific node types      //
//      3) providing implementation of tools thru call-backs into a .dll   //
//      4) monitoring IDE events such as Project Open and Close to         //
//          perform customized actions                                     //
//                                                                         //
//  With IdeHook users have access to the following areas of the IDE:      //
//                                                                         //
//      1)  Tool Server -   allows for installation, querying and          //
//                          invokation of any tool in the IDE              //
//      2)  Project Manager full access to the dependency tree of the      //
//                          currently open project including the ability   //
//                          to add new nodes, query the tree and set/get   //
//                          persistent properties into the project         //
//      3)  TargetExpert    allows callers to create and query targets     //
//                          of any platforms                               //
//      4)  StyleSheets     gives access to setting and getting options    //
//                          on any node in the tree                        //
//      5)  Make            access to make engine, including notifications //
//                          of make starts                                 //
//      6)  Editor                                                         //
//                                                                         //
///////////////////////////////////////////////////////////////////////    //
//  HOW TO USE:                                                            //
///////////////////////////////////////////////////////////////////////    //
//                                                                         //
//  Using IdeHook is very easy:                                            //
//                                                                         //
//      1)  Create a (or many) .cpp module that includes IDEHOOK.H         //
//          performing your specific functionality                         //
//      2)  Create a .dll using the two .objs provided with this           //
//          package and your own modules                                   //
//      3)  In the end-users Windows directory, modify BCW.INI to          //
//          add the following section and key-value:                       //
//              [AddOns]                                                   //
//              addon000=yourdll.dll                                       //
//          where 'yourdll.dll' is the name of the dll you created in      //
//          step 2.                                                        //
//                                                                         //
//  The idehook.ide project should be installed under the root bc4         //
//  subdirectory.                                                          //
//                                                                         //
///////////////////////////////////////////////////////////////////////    //
//  TIPS AND CAVEATS                                                       //
///////////////////////////////////////////////////////////////////////    //
//                                                                         //
//  It is important to remember some things when using IdeHook:            //
//                                                                         //
//  1)  You can use the IDE to make your addon (the examples were          //
//      done that way and you should use the .ide file enclosed) however   //
//      in order to test your addon you will be modifying your BCW.INI,    //
//      so always remember to *remove* the [addons] section when you are   //
//      not testing.                                                       //
//                                                                         //
//  2)  Using the integrated debugger to debug your addon is out           //
//      of the question, use the standalone TDW on BCW.EXE loading         //
//      your addon using the 'name' field of the Modules window (F3).      //
//                                                                         //
//  3)  Link order is *very* important in making the .dll. Always          //
//      use the following order:                                           //
//          <yourLibMainModule>                                            //
//          idehook.obj                                                    //
//          <your modules....>                                             //
//                                                                         //
//  4)  If you GP the IDE the IDE will *not* unload your .dll. You         //
//      should either use a .dll unloader program or restart Windows.      //
//                                                                         //
//  5)  The IDE expects the key/value pairs of the [addons] section of     //
//      BCW.INI to be in numeric sequential order. It important that       //
//      you co-operate with and respect other addon vendors in this        //
//      regard. For example, by the time your addon is installed at        //
//      an end-user sight there might be several addons already installed: //
//          [AddOns]                                                       //
//          addon000=somedll.dll                                           //
//          addon001=another.dll                                           //
//          addon002=yetantr.dll                                           //
//      It is *your* responsibility to install your addon at the           //
//      end of this list (as 'addon03'). It is even more important when    //
//      you un-install that you keep the addons sequential. If there       //
//      have been other addons installed after yours, you must decrement   //
//      the numbers back to maintain a non-interrupted sequence.           //
//                                                                         //
//  6)  C++ exception throwing and catching has not been tested in an      //
//      addon .dll and neither has using OWL                               //
//                                                                         //
//  7)  AddOn unloading is tricky if you dynamically link to BC40RTL.DLL   //
//      due to a bug in the Windows unloader. If you are experiencing      //
//      problems dynamically linking to any .dll a suggested (if not       //
//      proven) work-around is to put a LoadLibrary/FreeLibrary pair of    //
//      calls into the WEP of the addon:                                   //
//                                                                         //
//          int FAR PASCAL WEP( int )                                      //
//          {                                                              //
//              FreeLibrary( LoadLibrary("somedll.dll") );                 //
//              ...                                                        //
//                                                                         //
//      If you can link statically, all the better.                        //
//                                                                         //
//  8)  The idehook.ide project assumes you have created deliver.exe from  //
//      examples\ide\deliver and put it in your path somewhere.            //
//                                                                         //
///////////////////////////////////////////////////////////////////////    //

#ifndef __IDEHOOK_H                                                        
#define __IDEHOOK_H

#ifndef __IDEHOOKT_H
#  include "idehookt.h"
#endif

///////////////////////////////////////////////////////////////////////  //
//  CLIENTS AND SERVERS                                                  //
///////////////////////////////////////////////////////////////////////  //
//                                                                       //
//  The IDE is built on an API exchange architecture. The APIs are       //
//  well defined and understood by all parties and the implementors      //
//  of these APIs are responsible for registering themselves as          //
//  such and servicing requests for the given API.                       //
//                                                                       //
//  IdeHook exposes serveral IDE servers:                                //
//                                                                       //
//      ToolServer                                                       //
//      ProjectServer                                                    //
//      TargetExpert                                                     //
//      OptionSetServer                                                  //
//      MakeServer                                                       //
//                                                                       //
//  In order to gain access to these servers, each one comes with a      //
//  'requestor' that implements the proper request and release           //
//  sequence:                                                            //
//                                                                       //
//      Server                  Requestor                                //
//      ----------------        ------------------                       //
//      ToolServer              ToolReq                                  //
//      ProjectServer           ProjectReq                               //
//      TargetExpert            TargetExpertReq                          //
//      OptionSetServer         OptionSetReq                             //
//      MakeServer              MakeReq                                  //
//                                                                       //
//                                                                       //
//  All you have to do to get a service, is instantiate it's requestor:  //
//                                                                       //
//      {                                                                //
//          ToolReq     toolServer;         // This gets a ToolServer    //
//                                                                       //
//          toolServer->ToolInvoke( ... );  // Call the server           //
//                                                                       //
//      }                                   // The server released here  //
//                                                                       //
//                                                                       //
//                                                                       //
//  In order to get called back for notification of events, tool         //
//  invokations or query responders, some servers provide you with a     //
//  'client' class that you are responsible for implementing and         //
//  registering with the server.                                         //
//                                                                       //
///////////////////////////////////////////////////////////////////////////
                                                                         


//////////////////////////////////////////////////////////////////
//                                                              //
//      TOOL CLIENT/SERVER                                      //
//                                                              //
//////////////////////////////////////////////////////////////////


//                                                                  //
//  ToolClient                                                      //
//                                                                  //
//      This class is used as a shell for your implementation of    //
//      tool call-backs.                                            //
//                                                                  //
class _HOOKCLASS ToolClient
{

};

//                                                                      //
//  ToolServer                                                          //
//                                                                      //
//      This is the IDE's tool server, use it to query, add, remove     //
//      and invoke any tool in the IDE.                                 //
//                                                                      //
//      There are two sides to Tool installing:                         //
//                                                                      //
//          1)  'Installing' a Tool into the user's project that        //
//              appears on either the 'Tool' menu or on some SpeedMenu  //
//              of a node type. This Tool can implemented as either a   //
//              standalone .exe or call-back into your addon .dll.      //
//              This is done on a project-by-project basis.             //
//                                                                      //
//          2)  'Registering' the impelmentor of a call-back style      //
//              Tool installed in step 1). This only needs to be done   //
//              once per instance of BCW.EXE.                           //
//                                                                      //
class _HOOKCLASS ToolServer
{
public:

    //                                                     //
    //  Register one or many tool call-back implementors.  //
    //                                                     //
    virtual void     _HOOKEP    ToolRegisterImplementor
                                (
                                    ToolClient *,
                                    ToolRegisterPack *
                                ) = 0;

    //                                          //
    //  Install a tool into the user's project  //
    //                                          //
    virtual ToolObj    _HOOKEP    ToolAdd
                                (
                                    ToolInfo * 
                                ) = 0;

    //                                                       //
    //  Query the existance of a tool in the current project //
    //                                                       //
    virtual ToolObj    _HOOKEP    ToolFind
                                (
                                    const char * name 
                                ) = 0;

    //                                           //
    //  Remove a tool from the current project   //
    //                                           //
    virtual void    _HOOKEP    ToolRemove
                                (
                                    const char * name
                                ) = 0;
                                 
    //                                             //
    //  Query the detailed information of a tool   //
    //                                             //
    virtual void    _HOOKEP    QueryToolInfo
                                ( 
                                    ToolObj, 
                                    ToolInfo &
                                 ) = 0;

    //                                                              //
    //  Invoke any tool in the IDE. If 'ProjectNode' is zero, the   //
    //  tool is invoked on the 'currently selected object' in the   //
    //  IDE as determined by the IDE.                               //
    //                                                              //
    virtual ToolReturn _HOOKEP    ToolInvoke
                                (
                                    ToolObj,
                                    ProjectNode = 0,
                                    const char * cmdLineOverride = 0
                                ) = 0;                                 

    virtual ToolReturn _HOOKEP    ToolInvoke
                                (
                                    ToolObj,
                                    const char * edName,
                                    const char * cmdLineOverride = 0
                                ) = 0;                                 

};



//////////////////////////////////////////////////////////////////
//                                                              //
//      PROJECT SERVER/CLIENT                                   //
//                                                              //
//////////////////////////////////////////////////////////////////

//                                                            //
//  ProjectClient                                             //
//                                                            //
//      Client class for notification of project events and   //
//      query call-backs.                                     //
//                                                            //
//      For example, if you wish to get notified of every     //
//      Project Open event, derive and implement this class   //
//      and register by calling the                           //
//      ProjectServer::RegisterProjectClient method.          //
//                                                            //
                                                              
class _HOOKCLASS ProjectClient
{
public:

    //                                                        //
    //  Project Open notify event: This is called every time  //
    //  a user is successful in opening a project...          //
    //                                                        //
    virtual void _HOOKEP   OpenNotify
                                    (
                                        const char * name 
                                    ) = 0;
    
    //                                                          //
    //  Project Close notify event: This is called every time   //
    //  a project closing (either explicitly or on the way      //
    //  to a project open).                                     //
    //                                                          //
    virtual void _HOOKEP   CloseNotify() = 0;                   

    //                                                          //
    //  Node delete event: This is called every time the        //
    //  user explicitly deletes a node                          //
    //                                                          //
    virtual void _HOOKEP   NodeDeleteNotify
                                    (
                                        ProjectNode
                                    ) = 0;
      
    //                                             //
    //  This is used as a call back to the         //
    //  ProjectServer::QueryDependencies method.   //
    //                                             //
    virtual void _HOOKEP   DependencyQueryResponder
                                    (
                                        ProjectNode , 
                                        const char * outputName
                                    ) = 0;
};


//                                                                 //
//  ProjectServer                                                  //
//                                                                 //
//      Provides access to the current project's dependency tree.  //
//                                                                 //
//      The 'ProjectNode' cookie passed around in this (and other  //
//      APIs) is a persistent 32 bit entity across sessions. You   //
//      can safely store this value away in your own supplemental  //
//      files and refer to them at later sessions.                 //
//                                                                 //
class _HOOKCLASS ProjectServer
{
public:

    //                                                       //
    //  Register your implementation of a project client...  //
    //                                                       //
    virtual void            _HOOKEP    RegisterProjectClient
                            (
                                ProjectClient *
                            ) = 0;

    //                                                    //
    //  Release your implementation of a project client   //
    //                                                    //
    virtual void             _HOOKEP    UnregisterProjectClient
                            (
                                ProjectClient *
                            ) = 0;
      
    //                                                                  //
    //  Add a node into the project tree. If 'parent' is 0, then        //
    //  it is added as a second level node (dependent of the [.ide]).   //
    //  If 'type' is 0, then 'name' is assumed to be a file name with   //
    //  an extension that is used as the node type. For example:        //
    //                                                                  //
    //      To add a file:                                              //
    //          NodeAdd( parent, "foo.cpp" );   // OR:                  //
    //          NodeAdd( parent, "foo", ".cpp" );                       //
    //                                                                  //
    //      To add a SourcePool:                                        //
    //          NodeAdd( parent, "The Shared Sources", "SourcePool" );  //
    //                                                                  //
    virtual ProjectNode     _HOOKEP    NodeAdd
                            (
                                ProjectNode  parent,
                                const char * name, 
                                const char * type = 0 
                            ) = 0;

    //                                            //
    //  Find any instance of a node in the tree   //
    //                                            //
    virtual ProjectNode    _HOOKEP    NodeFind
                            (
                                const char * name 
                            ) = 0;
      
    //                                                         //
    //  Remove a node and all it's dependencies from the tree  //
    //                                                         //
    virtual ProjectNode    _HOOKEP    NodeRemove
                            (
                                ProjectNode 
                            ) = 0;

    //                                                 //
    //  Return the top level [.ide] node for the tree  //
    //                                                 //
    virtual ProjectNode    _HOOKEP    QueryTopNode() = 0;
    
    //                                                            //
    //  Query detailed information about a given node in the tree //
    //                                                            //
    virtual void            _HOOKEP    QueryNodeInfo
                            (
                                ProjectNode,
                                ProjectNodeInfo &
                            ) = 0;
      
    //                                                               //
    //  Query the dependencies of a given node in the tree. (This    //
    //  method will 'collapse' SourcePool nodes recursing into       //
    //  them as if they were not there.) For every dependency found  //
    //  the ProjectClient::DependencyQueryResponder() method is      //
    //  called with the 'ProjectNode' and output location for that   //
    //  node.                                                        //
    //                                                               //
    virtual void            _HOOKEP    QueryDependencies             
                            (
                                ProjectNode,
                                ProjectClient *
                            ) = 0;


    //                                                               //
    //  NodePropertySet/Get/Remove allows you to create and maintain //
    //  persistent named properties on any node in any project. The  //
    //  'propertyName' field must be unique to every property on     //
    //  a given node. It therefore recommended you use some kind of  //
    //  trademark name or initials in order not to conflict with     //
    //  other addon vendors.                                         //
    //                                                               //
    virtual void            _HOOKEP    NodePropertySet               
                            (
                                ProjectNode     node,
                                const char *    propertyName,
                                void *          data,
                                size_t          dataSize
                            ) = 0;

    virtual size_t            _HOOKEP    NodePropertyFind
                            (
                                ProjectNode     node,
                                const char *    propertyName,
                                const void * &  data
                            ) = 0;

    virtual void            _HOOKEP    NodePropertyRemove
                            (
                                ProjectNode     node,
                                const char *    propertyName
                            ) = 0;


    //                                                         //
    //  This will return the user's currently selected nodes   //
    //  in the project.                                        //
    //                                                         //
    virtual int             _HOOKEP    QuerySelectedNodes
                            (
                                ProjectNode * & nodeArray,
                                int &           numNodes
                            ) = 0;
                                                            
};


//////////////////////////////////////////////////////////////////
//                                                              //
//      OPTIONSET SERVER                                        //
//                                                              //
//////////////////////////////////////////////////////////////////

//                                                                 //
//  OptionSetServer                                                //
//                                                                 //
//      Gives access to certain local overrides on node's options. //
//      The options available are given in an enum called          //
//      OptionsStringIds in IDEHOOKT.H                             //
//                                                                 //
class _HOOKCLASS OptionSetServer
{
public:

    //                                                      //
    //  Set the node's local override for the given option  //
    //                                                      //
    virtual void   _HOOKEP    OptionApply
                                        ( 
                                            ProjectNode         node,
                                            OptionsStringIds    oid,
                                            const char *        value
                                        ) = 0;

    //                                                      //
    //  Get the node's local override for the given option  //
    //                                                      //
    virtual size_t _HOOKEP    OptionGet
                                        ( 
                                            ProjectNode         node,
                                            OptionsStringIds    oid,
                                            const char * &      value
                                        ) = 0;

    //                                                             //
    //  Remove the node's local override for the given option, or  //
    //  *all* local overrides if oid == OID_RemoveAll.             //
    //                                                             //
    virtual void   _HOOKEP    OptionRemove
                                        (
                                            ProjectNode         node,
                                            OptionsStringIds    oid
                                        ) = 0;
};

//////////////////////////////////////////////////////////////////
//                                                              //
//      TARGET EXPERT                                           //
//                                                              //
//////////////////////////////////////////////////////////////////

//                                                                    //
//  TargetExpert                                                      //
//                                                                    //
//      Allows for adding and querying target nodes into              //
//      dependency tree. The TargetExpert expert will automatically   //
//      create the proper library skeleton and set the proper         //
//      options for the given platform, memory model, etc.            //
//                                                                    //
class _HOOKCLASS TargetExpert                                         
{
public:

    //                                                         //
    //  Add a target into the project dependency tree..        //
    //                                                         //
    virtual ProjectNode _HOOKEP    TargetAdd
                                        (
                                            const char *    name,
                                            TargetPlatforms platform,
                                            TargetStdLibs   libs,
                                            TargetModel     image,
                                            ProjectNode     parent = 0,
                                            const char *    type = 0
                                        ) = 0;

    //                                                //
    //  Query if a ProjectNode is actually a target   //
    //                                                //
    virtual int         _HOOKEP    NodeIsTarget
                                        (
                                            ProjectNode
                                        ) = 0;

    //                                                              //
    //  Climb 'up' the dependency tree returning the node's target  //
    //                                                              //
    virtual ProjectNode _HOOKEP    FindNodesTarget
                                        (
                                            ProjectNode
                                        ) = 0;

    //                                                              //
    //  Query whether a given node (target or not) supports the     //
    //  given platform, libraries and/or image. If any of the       //
    //  query parameters are 0, then that attribute is not part     //
    //  of the query. For example:                                  //
    //                                                              //
    //      To see if a node is a Win32 compile:                    //
    //          QuerySupports( node, Win32, 0, 0 );                 //
    //                                                              //
    //      To see if a node is OWL:                                //
    //          QuerySupports( node, 0, OWL, 0 );                   //
    //                                                              //
    //      To see if a node is a large model Dos overly with BGI:  //
    //          QuerySupports( node, DosOverlay, BGI, Large );      //
    //                                                              //
    virtual int         _HOOKEP    QuerySupports
                                        (
                                            ProjectNode     node,
                                            TargetPlatforms platform,
                                            TargetStdLibs   libs,
                                            TargetModel     image
                                        ) = 0;
    
};


//////////////////////////////////////////////////////////////////
//                                                              //
//      MAKE                                                    //
//                                                              //
//////////////////////////////////////////////////////////////////

class _HOOKCLASS MakeClient
{
public:
    virtual void MakeBeginNotify() = 0;
    virtual void MakeEndNotify()   = 0;
};

class _HOOKCLASS MakeServer
{
public:
    virtual void        _HOOKEP    RegisterMakeClient
                                (
                                    MakeClient *
                                ) = 0;

    virtual void        _HOOKEP    UnRegisterMakeClient
                                (
                                    MakeClient *
                                ) = 0;

    virtual void        _HOOKEP    MakeNodes
                                (
                                    MakeMode,
                                    ProjectNode *, 
                                    int numNodes = 1 
                                 ) = 0;

    virtual long        _HOOKEP     NodeInputAge
                                (
                                    ProjectNode
                                ) = 0;

    virtual long        _HOOKEP     NodeOutputAge
                                (
                                    ProjectNode
                                ) = 0;

};


//////////////////////////////////////////////////////////////////
//                                                              //
//      EDITOR                                                  //
//                                                              //
//////////////////////////////////////////////////////////////////

class _HOOKCLASS EditorServer
{
public:

  //                                                                          //
  // This first section is taken from the BRIEF macro language guide. These   //
  // routines are documented there. Only differences from those semantics are //
  // listed. String manipulation routines are not listed here as the caller   //
  // may use the RTL.                                                         //
  //                                                                          //
  
  virtual int _HOOKEP       beginning_of_line() = 0;

  virtual int _HOOKEP       backspace() = 0;

  //                                                        //
  //  buffer_name and system are ignored for this version   //
  //                                                        //
  virtual BufferId _HOOKEP  create_buffer
                                (
                                    char  * buffer_name,
                                    char  * file_name,
                                    int        system = 0
                                ) = 0;

  virtual int _HOOKEP       delete_block() = 0;

  //                                                              //
  //    delete_buffer deletes buffer from memory if there are no  //
  //    windows containing views on the buffer.                   //
  //                                                              //
  virtual int _HOOKEP       delete_buffer
                                (
                                    BufferId buffer_id
                                ) = 0;

  virtual int _HOOKEP       delete_char
                                (
                                    int num_to_delete = 1
                                ) = 0;

  virtual void _HOOKEP      delete_line() = 0;

  virtual void _HOOKEP      delete_to_eol() = 0;

  virtual long _HOOKEP      distance_to_tab() = 0;

  virtual int _HOOKEP       down() = 0;

  virtual void _HOOKEP      drop_anchor
                                (
                                    char mark_type = 1
                                ) = 0;

  virtual int _HOOKEP       end_of_buffer() = 0;

  virtual int _HOOKEP       end_of_line() = 0;

  virtual int _HOOKEP       end_of_window() = 0;

  virtual int _HOOKEP       goto_line
                                (
                                    long line
                                ) = 0;

  virtual int _HOOKEP       goto_old_line
                                (
                                    long line
                                ) = 0;

  virtual BufferId _HOOKEP inq_buffer
                                (
                                    char  * fileName = 0
                                ) = 0;

  //                                                                   //
  //  inq_line_length returns the length of the current line in chars. //
  //                                                                   //
  virtual int _HOOKEP       inq_line_length() = 0;

  virtual int _HOOKEP       inq_modified() = 0;

  virtual void _HOOKEP      inq_names
                                (
                                    char  * full_name = 0,
                                    char  * extension = 0,
                                    char  * buffer_name = 0
                                ) = 0;

  virtual int _HOOKEP       inq_position
                                (
                                    long  *  line = 0,
                                    long  *  col = 0
                                ) = 0;

  virtual int _HOOKEP       inq_views
                                (
                                    BufferId buffer_id = 0
                                ) = 0;

  //                                         //
  //  insert adds only the control string    //
  //                                         //
  virtual void _HOOKEP      insert
                                (
                                    char  * control_string
                                ) = 0;

  virtual int _HOOKEP       left() = 0;

  virtual int _HOOKEP       move_abs
                                (
                                    long line = 0,
                                    long column = 0
                                ) = 0;

  virtual int _HOOKEP       move_rel
                                (
                                    long num_lines = 0,
                                    long num_columns = 0
                                ) = 0;

  virtual BufferId _HOOKEP  next_buffer
                                (
                                    int system_too = 0
                                ) = 0;

  virtual int _HOOKEP       next_char
                                (
                                    int num_chars = 1
                                ) = 0;

  virtual int _HOOKEP       page_down() = 0;

  virtual int _HOOKEP       page_up() = 0;

  virtual int _HOOKEP       prev_char
                                (
                                    int num_chars = 1
                                ) = 0;

  virtual void _HOOKEP      raise_anchor() = 0;

  //                                                             //
  //    NOTE:   Make sure to call free_string() with the return  //
  //            value from here...                               //
  //                                                             //
  virtual char * _HOOKEP    read
                                (
                                    int length = 0
                                ) = 0;

  virtual int _HOOKEP       read_file
                                (
                                    char  * filename
                                ) = 0;

  virtual void _HOOKEP      refresh() = 0;

  virtual int _HOOKEP       right() = 0;

  virtual int _HOOKEP       search_back
                                (
                                    const char* pattern,
                                    int         regex   = 1,
                                    int         caseSen = 1,
                                    int         block   = 0,
                                    long  *     total_length = 0,
                                    int         grep    = 0
                                ) = 0;

  virtual int _HOOKEP       search_fwd
                                (
                                    const char *    pattern,
                                    int             regex   = 1,
                                    int             caseSen = 1,
                                    int             block   = 0,
                                    long *          total_length = 0,
                                    int             grep    = 0
                                ) = 0;

  virtual BufferId _HOOKEP  set_buffer
                                (
                                    BufferId buffer_id
                                ) = 0;

  virtual void _HOOKEP      set_top_left
                                (
                                    long        top_line = 0,
                                    long        left_col = 0,
                                    ViewId      window_id = 0,
                                    long        line = 0,
                                    long        col = 0,
                                    BufferId    buffer_id = 0
                                ) = 0;

  virtual int _HOOKEP       top_of_buffer() = 0;

  virtual int _HOOKEP       top_of_window() = 0;

  virtual int _HOOKEP       translate
                                (
                                    char  * pattern,
                                    char  * replacment,
                                    int     global_flag,
                                    int     regex   = 1,
                                    int     caseSen = 1,
                                    int     block   = 0,
                                    int     forward = 1,
                                    int     grep    = 0
                                ) = 0;

  virtual int _HOOKEP       up() = 0;

  virtual int _HOOKEP       write_buffer() = 0;

  //----------------------------------------------------------------//
  //    This section consists of additional routines that can       //
  //    not be built with the BRIEF primitives                      //
  //                                                                //
                                                                    //
  //                                                                //
  //  Free storage allocated by calls to read                       //
  //                                                                //
  virtual void _HOOKEP      free_string                             
                                (
                                    char  * str      //  string to free 
                                ) = 0;

  //                                                                   //
  //    show_buffer moves an MDI window on the current buffer to       //
  //    top of window stack. If no such window exists, one is created. //
  //                                                                   //
  virtual void _HOOKEP      show_buffer() = 0;

  virtual int _HOOKEP       save_buffer() = 0;

  virtual int _HOOKEP       register_keyhit_handlers
                                ( 
                                    KeyStroke   *   keyStrokes,
                                    int             numKeyStrokes
                                ) = 0;
};


////////////////////////////////////////////////////
//  Service implementation                        //
//                                                //
//  For usage see the notes above...              //
////////////////////////////////////////////////////

extern void *   QueryService( int );
extern void     ReleaseService( int, void * );

template <class T, int id>
class __Req
{
public:
    __Req() : _id( id )     { _server = (T *)QueryService( id ); }
    ~__Req()                { if( _server ) 
                                ReleaseService( id, (void *)_server ); }
    operator T  * ()        { return( _server ); }
    T  * operator -> ()     { return( _server ); }
    int operator ! ()       { return( !_server ); }

private:
    T  * _server;
    int     _id;
};


#define SRVR_PROJECT        1
#define SRVR_TOOL           2
#define SRVR_OPTIONSET      3
#define SRVR_TARGETEXPERT   4
#define SRVR_MAKE           5
#define SRVR_EDITOR         6

////////////////////////////////////////////////////
//  Service usage...                              //
//                                                //
//  Use these typedefs when accessing a service,  //
//  when coming into scope the __Req   for the    //
//  service is made, when going out of scope the  //
//  service is released.                          //
////////////////////////////////////////////////////

typedef __Req<ProjectServer,  SRVR_PROJECT >     ProjectReq;
typedef __Req<ToolServer,     SRVR_TOOL    >     ToolReq;
typedef __Req<OptionSetServer,SRVR_OPTIONSET >   OptionSetReq;
typedef __Req<TargetExpert,   SRVR_TARGETEXPERT> TargetExpertReq;
typedef __Req<MakeServer,     SRVR_MAKE >        MakeReq;
typedef __Req<EditorServer,   SRVR_EDITOR >      EditorReq;


#endif  __IDEHOOK_H



