//                                               //
// Copyright <c> Borland International, 1993-4   //
//                                               //

//                                                                   //
//  CppNSee - Example of IdeHook usage.                              //
//                                                                   //
//      This examples demonstrates installing a tool that will       //
//      preprocess a .c or .cpp file and put the resulting .i file   //
//      into a new editor on the desktop.                            //
//                                                                   //
//      This is accomplished by using the existing C++ preprocessor  //
//      as a template for creating our own tool with a call-back     //
//      implementor. The call-back calls the original C++            //
//      preprocessor tool and then the 'EditText' tool with the      //
//      result.                                                      //
//                                                                   //
                                                                     
#pragma hdrstop

#include "idehook.h"
#include "pathspec.h"
#include <string.h>
#include <windows.h>

static char realCppPreprocess[]  = "CppPreprocessor";
static char myPreprocessorName[] = "CppPreprocessAndSee";


//                                                         //
//  Create a ToolClient that implements our CppNSee tool   //
//                                                         //

class _HOOKCLASS LocalToolClient : public ToolClient
{
public:
    ToolReturn _HOOKEP RunPreprocessor( ToolInvokeArgs * );

    void RegisterMyCallBacks( ToolServer * );

private:

            int                 registered;
    static  ToolRegisterPack    entryPoints[];

};

static LocalToolClient  localToolClient;

ToolRegisterPack LocalToolClient::entryPoints[] =
{
    { myPreprocessorName, (ToolMethod)&LocalToolClient::RunPreprocessor },
    { 0 }
};

void
LocalToolClient::RegisterMyCallBacks( ToolServer * ts )
{
    if( !registered )
    {
        //  Registration of the implementor should only happen  //
        //  once per instance of BCW                            //
        
        registered = 1;
        ts->ToolRegisterImplementor( this, entryPoints );
    }
}

static void near pascal postError( const char * msg )
{
    ::MessageBox( ::GetActiveWindow(), msg, "Error!", 
                              MB_ICONEXCLAMATION | MB_OK );
}                              


/////////////////////////////////////////////////////
//                                                 //
//  Here is the implementation of our tool....     //
//                                                 //
/////////////////////////////////////////////////////
    
ToolReturn _HOOKEP 
LocalToolClient::RunPreprocessor( ToolInvokeArgs * args )
{
    
    ToolReq   server;

    //  We can handle multiple selection ....
    
    int nodeCount = args->numNodes;


    //  Get the 'real' preprocessor tool...
    
    ToolObj preprocessor;
    
    if( nodeCount && ((preprocessor = server->ToolFind( realCppPreprocess )) == 0) )
    {
        postError( "Can't find C++ preprocessor tool!" );
        nodeCount = 0;                              
    }
        

    // Get the "EditText" tool to use for opening the file in the ide ...
    
    ToolObj editTool;

    if( nodeCount && ((editTool = server->ToolFind( "EditText" )) == 0) )
    {
        postError( "Can't find editor!" );
        nodeCount = 0;
    }                               

    ProjectReq   projectServer;

    // For every selected node ...
    
    for( int x = 0; x < nodeCount; x++ )
    {
        ProjectNode node = args->nodeArray[x];

        // Invoke the real preprocessor...
        
        if( server->ToolInvoke( preprocessor, node, 0 ) != Success )
        {
           postError( "CppPreprocess did not complete ok!" );
           nodeCount = 0;
           break;
        }

        //  Get the node's output location and change the extension
        //  to ".i" (that's what the real preprocessor did).
        
        ProjectNodeInfo     nodeInfo;

        projectServer->QueryNodeInfo( node, nodeInfo );

        PathSpec    nodePath( nodeInfo.outputLocation );

        nodePath.ext( ".i" );

        //  Invoke the "EditText" tool ...
        
        if( server->ToolInvoke( editTool, nodePath.path()) != Success )
        {
            postError( "Opening editor failed" );
            nodeCount = 0;
            break;
        }
    }

    return( nodeCount ? Success : Errors );

}

//                                                                    //
//      Register this tool into user's projects. We do this by        //
//      watching for Project Open's.                                  //
//                                                                    //

class _HOOKCLASS LocalProjClient : public ProjectClient
{
public:
  LocalProjClient();
   
  virtual void _HOOKEP OpenNotify( const char * name );
  virtual void _HOOKEP CloseNotify() {}
  virtual void _HOOKEP NodeDeleteNotify( ProjectNode ) {}
  virtual void _HOOKEP DependencyQueryResponder( ProjectNode, const char * ) {}

};

static LocalProjClient LocalProjClient;

LocalProjClient::LocalProjClient()
{
   //   Register ourselves as a project client so we'll get notified  //
   //   on project open's                                             //
   
   ProjectReq ps;

   ps->RegisterProjectClient(this);
}


void _HOOKEP    
LocalProjClient::OpenNotify
(
   const char * // name 
)
{
    ToolReq   ts;

    //  First, register this .dll as a tool implementor ...

    localToolClient.RegisterMyCallBacks( ts );

    // ...then look to see if the user's project already has this tool:  //

    if( !ts->ToolFind( myPreprocessorName ) )
    {
        //  Ok, the user does not have this tool in their project, so  //
        //  let's install it...                                        //

        ToolObj realPreProcessor;

        //  We start by looking for the 'real' preprocessor ... 

        if( (realPreProcessor = ts->ToolFind( realCppPreprocess )) != 0 )
        {
            //  Once found, we use QueryToolInfo() to fill in the  //
            //  toolInfo struct for us.                            //

            ToolInfo toolInfo;

            ts->QueryToolInfo( realPreProcessor, toolInfo );

            // We make our customizations to the structure...

            toolInfo.toolType       = Viewer;
            toolInfo.menuName       = "&Preprocess and see";
            toolInfo.defCmdLine     = 0;
            toolInfo.helpHint       = "Preprocess a c/c++ file and dump"
                                      " into editor";
            toolInfo.launchId       = CALLBACK_LAUNCH_ID;

            // ...give it our name...

            toolInfo.name           = myPreprocessorName;

            // ... and add it to the project !

            ts->ToolAdd( &toolInfo );
        }
    }

}
      

// End of file
