//                                               //
// Copyright <c> Borland International, 1993-4   //
//                                               //

//                                                                   //
//  TrgSnps - Example of IdeHook usage.                              //
//                                                                   //
//      This examples demonstrates installing a tool that will       //
//      create a basic node skeleton and generate source files       //
//      for a target based on the type of target (Dos, Window,       //
//      OWL, etc).                                                   //
//                                                                   //

#pragma hdrstop

#include "idehook.h"
#include "pathspec.h"
#include <string.h>
#include <windows.h>

static char targetExeSnipName[] = "TargetExeSnippets";

#define CRLF "\n"

static char szExeWinMain[] =
   "//"                                   CRLF
   "//     This is the WinMain snippet"   CRLF
   "//"                                   CRLF 
   "#include <windows.h>"                 CRLF
                                          CRLF
   "int WINAPI WinMain"                   CRLF
   "("                                    CRLF
   "   HINSTANCE /* hInstance */,"        CRLF
   "   HINSTANCE /* hPrevInstance */, "   CRLF
   "   LPSTR     /* lpCmdLine */,"        CRLF
   "   int       /* howShow */"           CRLF
   ")"                                    CRLF
   "{"                                    CRLF
   "   return(0);"                        CRLF
   "}"                                    CRLF
   ;

static char szExeOwlMain[] =
   "//"                                                    CRLF
   "//     This is the OwlMain snippet"                    CRLF
   "//"                                                    CRLF
   "#include <owl/applicat.h>"                             CRLF
                                                           CRLF
   "int OwlMain( int /* argc */ , char ** /* argv */ )"    CRLF
   "{"                                                     CRLF
   "   return( TApplication().Run() );"                    CRLF
   "}"                                                     CRLF
   ;

static char szExeDefSnip[] =
   "EXETYPE WINDOWS"                     CRLF
   "CODE PRELOAD MOVEABLE DISCARDABLE"   CRLF
   "DATA PRELOAD MOVEABLE MULTIPLE"      CRLF
   "HEAPSIZE 4096"                       CRLF
   "STACKSIZE 8192"                      CRLF
   ;

//                                                         //
//  Create a ToolClient that implements our TrgSnps tool   //
//                                                         //

   
class _HOOKCLASS LocalToolClient : public ToolClient
{
public:
    ToolReturn _HOOKEP RunTargetExeSnips( ToolInvokeArgs * );
                                       
    void RegisterMyCallBacks( ToolServer * );

private:
            int                 registered;
    static  ToolRegisterPack    entryPoints[];

};

void
LocalToolClient::RegisterMyCallBacks( ToolServer * ts )
{
    if( !registered )
    {
        //  Registration of the implementor should only happen  //
        //  once per instance of BCW                            //
        
        registered = 1;
        ts->ToolRegisterImplementor( this, entryPoints );
    }
}

ToolReturn _HOOKEP 
LocalToolClient::RunTargetExeSnips( ToolInvokeArgs * args )
{
    ToolReq   server;

    //  This tool does not support multiple selection, so 
    //  just get the first node in the selection.

    ProjectNode node = args->numNodes ? *args->nodeArray : 0;

    if( node )
    {
        ProjectNodeInfo    nodeInfo;
        ProjectReq         project;
        PathSpec           nodePath;
        EditorReq          editor;

        project->QueryNodeInfo( node, nodeInfo );

        nodePath.path( nodeInfo.outputLocation );

        //                                 //
        // Do the [.cpp] main source node  //
        //                                 //
        
        nodePath.ext( ".cpp" );

        project->NodeAdd( node, nodePath.path() );

        editor->set_buffer( editor->create_buffer( 0,
                                                   (char *)nodePath.path(),
                                                   0 ) );

        TargetExpertReq    targetExpert;

        const char * mainSnip;
         
        if( targetExpert->QuerySupports( node, TargetPlatforms(0), OWL, 
                                                    TargetModel(0) ) )
           mainSnip = szExeOwlMain;
        else
           mainSnip = szExeWinMain;

        editor->insert( (char *)mainSnip );

        editor->show_buffer();
        
        //                                 //
        // Do the [.def] main source node  //
        //                                 //
        
        nodePath.ext( ".def" );
        project->NodeAdd( node, nodePath.path() );
        editor->set_buffer( editor->create_buffer( 0,
                                                   (char *)nodePath.path(),
                                                   0 ) );
        editor->insert( szExeDefSnip );
    }

    return( Success );

}

static LocalToolClient  localToolClient;

ToolRegisterPack LocalToolClient::entryPoints[] =
{
    { targetExeSnipName, (ToolMethod)&LocalToolClient::RunTargetExeSnips },
    { 0 }                                                          
};


//                                                                    //
//      Register this tool into user's projects. We do this by        //
//      watching for Project Open's.                                  //
//                                                                    //

class _HOOKCLASS LocalProjClient : public ProjectClient
{
public:
   LocalProjClient();
   
 virtual void _HOOKEP OpenNotify( const char * name );
 virtual void _HOOKEP CloseNotify() {}
 virtual void _HOOKEP NodeDeleteNotify( ProjectNode ) {}
 virtual void _HOOKEP DependencyQueryResponder(ProjectNode,const char *) {}

};

static LocalProjClient LocalProjClient;

LocalProjClient::LocalProjClient()
{
   //   Register ourselves as a project client so we'll get notified  //
   //   on project open's                                             //
   
   ProjectReq ps;

   ps->RegisterProjectClient(this);
}


void _HOOKEP    
LocalProjClient::OpenNotify
(
   const char * // name 
)
{
    ToolReq   ts;

    //  First, register this .dll as a tool implementor ...

    localToolClient.RegisterMyCallBacks( ts );


    // ...then look to see if the user's project already has this tool:  //

    if( !ts->ToolFind( targetExeSnipName ) )
    {
        //  Ok, the user does not have this tool in their project, so  //
        //  let's install it...                                        //

        ToolInfo toolInfo;
        
        toolInfo.toolType      = Viewer;
        toolInfo.name          = targetExeSnipName;
        toolInfo.path          = 0;
        toolInfo.flags         = OnLocalMenu;
        toolInfo.menuName      = "&Target snippets";
        toolInfo.helpHint      = "Generate a skeleton for a target";
        toolInfo.defCmdLine    = 0;
        toolInfo.appliesTo     = ".exe;";
        toolInfo.defaultFor    = 0;
        toolInfo.translateTo   = 0;
        toolInfo.launchId      = CALLBACK_LAUNCH_ID;

        ts->ToolAdd( &toolInfo );
    }
   
}
    
// End of file
