//                                               //
// Copyright <c> Borland International, 1993-4   //
//                                               //

//                                                                   //
//  WipeOpts -  Example of IdeHook usage.                            //
//                                                                   //
//      This examples demonstrates installing a tool that will       //
//      remove any local options from the current selected nodes     //
//      and all of it's dependencies.                                //
//                                                                   //

#pragma hdrstop

#include "idehook.h"
#include <string.h>

static char wipeOptsName[] = "OptionsWiper";



//                                                         //
//  Create a ToolClient that implements our WipeOpts tool  //
//                                                         //

class _HOOKCLASS LocalToolClient : public ToolClient
{
public:
    ToolReturn _HOOKEP RunOptionWiper( ToolInvokeArgs * );

    void RegisterMyCallBacks( ToolServer * );

private:

   void WipeNodeOptions( ProjectNode, ProjectServer *, OptionSetServer * );
   
            int                 registered;
    static  ToolRegisterPack    entryPoints[];

};


void
LocalToolClient::RegisterMyCallBacks( ToolServer * ts )
{
    if( !registered )
    {
        //  Registration of the implementor should only happen  //
        //  once per instance of BCW                            //
        
        registered = 1;
        ts->ToolRegisterImplementor( this, entryPoints );
    }
}

/////////////////////////////////////////////////////
//                                                 //
//  Here is the implementation of our tool....     //
//                                                 //
/////////////////////////////////////////////////////

void 
LocalToolClient::WipeNodeOptions
(
   ProjectNode        node, 
   ProjectServer *    projectServer, 
   OptionSetServer *  optSetServer
)
{
    optSetServer->OptionRemove( node, OID_RemoveAll );

    ProjectNodeInfo    nodeInfo;

    projectServer->QueryNodeInfo( node, nodeInfo );

    node = nodeInfo.firstChild;

    while( node )
    {
       WipeNodeOptions( node, projectServer, optSetServer );

       projectServer->QueryNodeInfo( node, nodeInfo );

       node = nodeInfo.nextSibling;
    }
}

ToolReturn _HOOKEP 
LocalToolClient::RunOptionWiper( ToolInvokeArgs * args )
{
    int count = args->numNodes;

    ProjectReq     projectServer;
    OptionSetReq   optSetServer;
    
    for( int i = 0; i < count; i++ )
    {
       ProjectNode   node = args->nodeArray[i];

       WipeNodeOptions( node, projectServer, optSetServer );
    }

    return( Success );
}


ToolRegisterPack LocalToolClient::entryPoints[] =
{
    { wipeOptsName, (ToolMethod)&LocalToolClient::RunOptionWiper },
    { 0 }
};

static LocalToolClient  localToolClient;


//                                                                    //
//      Register this tool into user's projects. We do this by        //
//      watching for Project Open's.                                  //
//                                                                    //


class _HOOKCLASS LocalProjClient : public ProjectClient
{
public:
    LocalProjClient();

    virtual void _HOOKEP OpenNotify( const char * name );
    virtual void _HOOKEP CloseNotify() {}
    virtual void _HOOKEP NodeDeleteNotify(ProjectNode) {}
    virtual void _HOOKEP DependencyQueryResponder(ProjectNode,const char * ) {}

};


LocalProjClient::LocalProjClient()
{
   ProjectReq ps;

   ps->RegisterProjectClient(this);
}


void _HOOKEP    
LocalProjClient::OpenNotify
(
   const char * // name 
)
{
    ToolReq   ts;

    //  First, register this .dll as a tool implementor ...

    localToolClient.RegisterMyCallBacks( ts );

    // ...then look to see if the user's project already has this tool:  //

    if( !ts->ToolFind( wipeOptsName ) )
    {
        //  Ok, the user does not have this tool in their project, so  //
        //  let's install it...                                        //

        ToolInfo toolInfo;

        toolInfo.toolType		= Transfer;
        toolInfo.name          = wipeOptsName;
        toolInfo.path          = 0;
        toolInfo.flags         = OnToolsMenu;
        toolInfo.menuName      = "&Options Wiper";
        toolInfo.helpHint      = "Delete the local overrides for node(s)";
        toolInfo.defCmdLine    = 0;
        toolInfo.appliesTo     = 0;
        toolInfo.defaultFor    = 0;
        toolInfo.translateTo   = 0;
        toolInfo.launchId      = CALLBACK_LAUNCH_ID;

        ts->ToolAdd( &toolInfo );
    }
}
    
static LocalProjClient LocalProjClient;

// End of file
