//                                               //
// Copyright <c> Borland International, 1993-4   //
//                                               //

//                                                                   //
//  SectComp - Example of IdeHook usage.                             //
//                                                                   //
//      This example demonstrates how to install a pre- and post-    //
//      compile process. Specifically the tool implemented here      //
//      will re-direct compiler output .obj to a different directory //
//      based on values in the node's defines options.               //
//                                                                   //
//      This is acheived by installing ourselves as a translator     //
//      of [.cpp] to [.obj], doing the options work here, but        //
//      then invoking the IDE's internal C++ compiler to do the      //
//      actual translation                                           //
//                                                                   //
//      This particular implementation helps cases like building     //
//      the OWL libraries where the source code gets compiled        //
//      serveral times, each time with a different value set on      //
//      a particular define (in this case "SECTION") and a           //
//      different output .obj based on that value of the define.     //
//                                                                   //

#pragma hdrstop

#include "idehook.h"
#include "pathspec.h"
#include <string.h>

static char realCppCompileName[]    = "CppCompile";
static char sectionCppCompileName[] = "SectionCppCompile";


//                                                         //
//  Create a ToolClient that implements our SectComp tool  //
//                                                         //


class _HOOKCLASS LocalToolClient : public ToolClient
{
public:
     ToolReturn _HOOKEP RunSectionCompiler( ToolInvokeArgs * );

     void RegisterMyCallBacks( ToolServer * );

private:

             int                 registered;
     static  ToolRegisterPack    entryPoints[];

};


void
LocalToolClient::RegisterMyCallBacks( ToolServer * ts )
{
     if( !registered )
     {
        //  Registration of the implementor should only happen  //
        //  once per instance of BCW                            //
        
          registered = 1;
          ts->ToolRegisterImplementor( this, entryPoints );
     }
}


//                                                              //
//   Here is the implementation of our "sectioning compiler"    //
//                                                              //

ToolReturn _HOOKEP 
LocalToolClient::RunSectionCompiler( ToolInvokeArgs * args )
{
            OptionSetReq    optSetServer;
            ProjectReq      projectServer;
            ToolReq         toolServer;
            
    static  char            szSection[] = "SECTION=";
            ProjectNode     node;
            int             nodeCount = args->numNodes;
            ToolReturn      ret = Success;
            ToolObj         realCompiler 
                                = toolServer->ToolFind( realCppCompileName );


    //                              //
    //  for every node selected ... //
    //                              //
    
    for( int x = 0; x < nodeCount; x++ )
    {
        node = args->nodeArray[x];

        //  Dig out the defines for this node ...       //
        
        const char *    defines;

        optSetServer->OptionGet( node, OID_Defines, defines );

        const char *    pSectionText;

        //  Search for the 'SECTION' string ...     //
        
        if( (pSectionText = strstr( defines, szSection)) != 0 )
        {
            // ...if found,  let's get the output name of the
            //  node and append the SECTION number to it.
            
            ProjectNodeInfo    nodeInfo;

            projectServer->QueryNodeInfo( node, nodeInfo );

            PathSpec           outPath( nodeInfo.outputLocation );

            char               newName[ MAXFILE + 2 ];

            strcpy( newName, outPath.file() );

            int    numberIndex = strlen(newName);

            if( numberIndex == 8 )
                 --numberIndex;

            newName[ numberIndex++ ] = *(pSectionText + (sizeof(szSection)-1));
            newName[ numberIndex ] = 0;

            outPath.file( newName );

            //  Now set the output name back into the node (this what the  //
            //  IDE compiler will use to output the .obj).                 //
            
            optSetServer->OptionApply( node, OID_Intermediate, outPath.path() );

        }

        //  In either case, call the C++ compiler   //
        
        if( (ret = toolServer->ToolInvoke( realCompiler, node )) != Success )
            break;

    }

    return( ret );

}

ToolRegisterPack LocalToolClient::entryPoints[] =
{
     { sectionCppCompileName, (ToolMethod)&LocalToolClient::RunSectionCompiler },
     { 0 }
};


static LocalToolClient  localToolClient;


//                                                                    //
//      Register this tool into user's projects. We do this by        //
//      watching for Project Open's.                                  //
//                                                                    //

class _HOOKCLASS LocalProjClient : public ProjectClient
{
public:
     LocalProjClient();
     
      virtual void _HOOKEP OpenNotify( const char * name );
      virtual void _HOOKEP CloseNotify() {}
      virtual void _HOOKEP NodeDeleteNotify(ProjectNode) {}
      virtual void _HOOKEP DependencyQueryResponder(ProjectNode, const char *) {}
};

LocalProjClient::LocalProjClient()
{
   //   Register ourselves as a project client so we'll get notified  //
   //   on project open's                                             //
   
    ProjectReq ps;

    ps->RegisterProjectClient(this);
}


void _HOOKEP    
LocalProjClient::OpenNotify
(
    const char * // name 
)
{
    //  First, register this .dll as a tool implementor ...
    
    ToolReq   ts;

    localToolClient.RegisterMyCallBacks( ts );

    //  Now, we need to register the tool. Are we already 
    //  registered?...
    
    if( !ts->ToolFind( sectionCppCompileName ) )
    {
        //  Ok, the user does not have this tool in their project, so  //
        //  let's install it...                                        //
        
        ToolObj realCppCompiler;

        if( (realCppCompiler = ts->ToolFind( realCppCompileName )) != 0 )
        {
            //  Once found, we use QueryToolInfo() to fill in the  //
            //  toolInfo struct for us.                            //
            
            ToolInfo toolInfo;

            ts->QueryToolInfo( realCppCompiler, toolInfo );

            // We make our customizations to the structure...
            
            toolInfo.menuName = "&Section Compiler";
            toolInfo.helpHint = "Munge outname of node then C++ Compile";
            toolInfo.launchId = CALLBACK_LAUNCH_ID;

            // ...give it our name...
                
            toolInfo.name     = sectionCppCompileName;
            
            ts->ToolAdd( &toolInfo );
        }
    }
     
}

static LocalProjClient LocalProjClient;
                      
// End of file
