//----------------------------------------------------------------------------
//  Hex Calculator almost exactly the same as Petzold's classic using OWL 2.0
//  Compile: make -fhcalc.mak
//  Fook H. Eng  09/20/94 (818) 572-9983, CIS id 76545,255
//----------------------------------------------------------------------------
#include <owl\owlpch.h>
#include <owl\applicat.h>
#include <owl\dc.h>
#include <owl\dialog.h>
#include <owl\framewin.h>
#include <ctype.h>

const char AppName[] = "Calc"; // Name of app, accel_table & icon resource id

// Calculator dialog window
//
class TCalc : public TDialog {
    public:
    TCalc(TWindow*, TResId, TModule* = 0);
    TBrush  WhiteBrush;
    TBrush  PurpleBrush;

    protected:
    LRESULT EvCommand(UINT, HWND, UINT);
    void    EvPaint();
    HBRUSH  EvCtlColor(HDC, HWND hWndChild, UINT ctlType);
    void    ShowNumber(DWORD number);
    void    CalcKey(char key);
    DWORD   CalcIt (DWORD dwFirstNum, char nOperation, DWORD dwNum);

    DECLARE_RESPONSE_TABLE(TCalc);
};

DEFINE_RESPONSE_TABLE1(TCalc, TDialog)
    EV_WM_PAINT,
    EV_WM_CTLCOLOR,
END_RESPONSE_TABLE;

//
// Calculator constructor.  Create two brushes for calculator background,
//
TCalc::TCalc(TWindow* parent, TResId resId, TModule* mod) : TDialog(parent, resId, mod),
                    WhiteBrush(TColor(255,255,255)), PurpleBrush(TColor(128,0,255)) { }

//
//  Colorize the calculator. Sets the background to either white or purple
//  if the WM_CTLCOLOR message is sent by the dialog box.  Sets background
//  to TRANSPARENT if the message is sent by a button.
//
HBRUSH TCalc::EvCtlColor(HDC hDC, HWND hWndChild, UINT ctlType)
{
    static int brushChoice = 0;

    brushChoice = 1 - brushChoice;     // toggles brush color selection makes
                                       // evident that case CTLCOLOR_DLG occurs
    switch (ctlType) {
        case CTLCOLOR_BTN:
            SetBkMode(hDC, TRANSPARENT);
            return (HBRUSH)GetStockObject(NULL_BRUSH);

        case CTLCOLOR_DLG:
            SetBkMode(hDC, TRANSPARENT);
            return (HBRUSH)(brushChoice ? WhiteBrush : PurpleBrush);

        default:
            return TDialog::EvCtlColor(hDC, hWndChild, ctlType);
    }
}

//
//  Even dialogs can have their backgrounds painted on.  This toggles a red
//  or blue ellipse over the prevailing background.
//
void TCalc::EvPaint()
{
    static int colorChoice = 0;

    colorChoice = 1 - colorChoice;          // toggles red/blue color choices

    TBrush    brush(TColor(colorChoice ? RGB(255,0,0) : RGB(0,0,255)));
    TPaintDC  dc(*this);

    dc.SelectObject(brush);
    dc.SelectStockObject(NULL_PEN);     // ellipse will be drawn sans border

    TRect clientRect = GetClientRect();
    clientRect.right = 2*clientRect.right/3;
    clientRect.bottom = 2*clientRect.bottom/3;
    clientRect.Offset(clientRect.right/2, clientRect.bottom/2);
    dc.Ellipse(clientRect);
}

//
//  here we handle all of the child id notifications (BN_CLICKED from the
//  buttons) and all accelerators at once rather than have separate response
//  table entries for each...
//  Key flashing is dispensed since it did not work too well.
//
LRESULT TCalc::EvCommand(UINT id, HWND hWndCtl, UINT notifyCode)
{
    if ((hWndCtl != 0 && notifyCode == BN_CLICKED) ||
                    (hWndCtl == 0 && notifyCode == 1))
        CalcKey(char(id));  // either button or accelerator notification

    return TDialog::EvCommand(id, hWndCtl, notifyCode);
}

//
// Set Display to the current value. Note VK_ESCAPE is id of display button.
//
void TCalc::ShowNumber(DWORD number)
{
    char  szBuffer[20];
    ::SetWindowText(GetDlgItem(VK_ESCAPE), strupr(ltoa(number, szBuffer, 16)));
}

#pragma warn -sig
DWORD TCalc::CalcIt (DWORD dwFirstNum, char nOperation, DWORD dwNum) {

     switch (nOperation) {

          case '=' : return dwNum ;
          case '+' : return dwFirstNum +  dwNum ;
          case '-' : return dwFirstNum -  dwNum ;
          case '*' : return dwFirstNum *  dwNum ;
          case '&' : return dwFirstNum &  dwNum ;
          case '|' : return dwFirstNum |  dwNum ;
          case '^' : return dwFirstNum ^  dwNum ;
          case '<' : return dwFirstNum << dwNum ;
          case '>' : return dwFirstNum >> dwNum ;
          case '/' : return dwNum ? dwFirstNum / dwNum : ULONG_MAX ;
          case '%' : return dwNum ? dwFirstNum % dwNum : ULONG_MAX ;
          default  : return 0L ;
     }
}
#pragma warn +sig

//
// Process calculator key.
//
void TCalc::CalcKey(char key) {

    static BOOL  bNewNumber = TRUE;
    static DWORD dwNumber, dwFirstNumber;
    static char  nOperation = '=';

    if (key == VK_BACK)                         // backspace
         ShowNumber (dwNumber >>= 4) ;

    else if (key == VK_ESCAPE)                  // escape
         ShowNumber (dwNumber = 0L) ;

    else if (isxdigit (key)) {
         if (bNewNumber) {                      // do bNewNumber stuff
              dwFirstNumber = dwNumber ;
              dwNumber = key - (isdigit(key) ? '0' : 'A' - 10);
              bNewNumber = FALSE;
              ShowNumber (dwNumber);
         }
         else if (dwNumber <= (ULONG_MAX >> 4)) {     // update working number
              dwNumber = (dwNumber << 4) + key - (isdigit(key) ? '0' : 'A' - 10);
              ShowNumber (dwNumber);
         }
         else
              MessageBeep (0) ;                 // No!! working number too large!
    }
    else {                                      // an arithmetical operation
         if (!bNewNumber) {
             dwNumber = CalcIt(dwFirstNumber, nOperation, dwNumber);
             ShowNumber (dwNumber);
             bNewNumber = TRUE;
         }
         nOperation = key ;
    }
}

//
// Calculator application object
//
class TCalcApp : public TApplication {

    public:
    TCalcApp(const char far* name) : TApplication(name) { }
    void   InitMainWindow();
};

//
// Create calculator as the application's main window.
//
void TCalcApp::InitMainWindow() {

    TWindow* calcWin = new TCalc(0, AppName);
    calcWin->Attr.AccelTable = AppName;

    MainWindow = new TFrameWindow(0, "HexCalc II", calcWin, TRUE);
    // title = "HexCalc II", clientWnd = calcWin, shrinkToClient = TRUE

    MainWindow->SetIcon(this, AppName);
    MainWindow->Attr.Style &= ~(WS_MAXIMIZEBOX | WS_THICKFRAME);
}

int OwlMain(int /*argc*/, char* /*argv*/ []) { return TCalcApp(AppName).Run(); }