/*  GETNOTES.C:
      Read the notes from a BC++ 3.1 or TC++ 3.0 project file
      and create a .not text file with those notes.
    EDJ 05-23-94
*/
#include  <alloc.h>
#include  <dir.h>
#include  <fcntl.h>
#include  <io.h>
#include  <process.h>
#include  <stdio.h>
#include  <string.h>
#include  <sys\stat.h>

//  TC++ 3.0 and BC++ 3.1 project version.
//
#define PROJECT_VERSION 0x0701

//  Offset into project file where version can be found.
//
#define VERSION_OFFSET  0x1E

//  Signature of the notes block.
//
#define NOTE_HEADER     0x34


int main( int argc, char **argv )
{
  int   inhandle,
        outhandle,
        versionNo,
        blockType,
        blockSize,
        bytesRead;
  char  exename[9]  = {'\0'},
        notname[13] = {'\0'},
        dontcare[120],
        *noteChunk  = 0;


  fnsplit( argv[0], dontcare, dontcare, exename, dontcare );

  if( argc < 2 )
  {
    printf( "Usage: %s <project file>\n", exename );
    exit( -1 );
  }

  inhandle  = open( argv[1], O_RDONLY | O_BINARY );
  if( inhandle < 0 )
  {
    printf( "Unable to open %s.\n", argv[1] );
    exit( -1 );
  }

  fnsplit( argv[1], dontcare, dontcare, notname, dontcare );
  strcat( notname, ".NOT");
  outhandle = open( notname, O_WRONLY | O_BINARY | O_CREAT,
    S_IREAD | S_IWRITE );

  if( inhandle < 0 )
  {
    printf( "Unable to open %s.\n", notname );
    exit( -1 );
  }

  lseek( inhandle, (long) VERSION_OFFSET, SEEK_SET );
  read( inhandle, &versionNo, sizeof( int ));

  if( versionNo != PROJECT_VERSION )
  {
    printf( "Wrong project version (%4X)\n", versionNo );
    exit( -1 );
  }
  
  bytesRead = read( inhandle, &blockType, sizeof( int));
  while( (blockType != NOTE_HEADER) && (bytesRead != 0))
  {
    read( inhandle, &blockSize, sizeof( int ));
    lseek( inhandle, (long) blockSize, SEEK_CUR );
    bytesRead = read( inhandle, &blockType, sizeof( int));
  }

  if( bytesRead == 0 )
  {
    printf( "No project notes found in %s\n", argv[1] );
    exit( 0 );
  }

  read( inhandle, &blockSize, sizeof( int ));
  noteChunk = (char *) malloc( blockSize );
  if( !noteChunk )
  {
    printf( "Couldn't allocate %d bytes for notes!\n", blockSize );
    exit( -1 );
  }

  bytesRead = read( inhandle, noteChunk, blockSize );
  write( outhandle, noteChunk, bytesRead );

  free( noteChunk );
  close( inhandle );
  close( outhandle );
    
  return 0;
}
