/**************************************************************************
These C++ classes are copyright 1989, 1990, 1991 by William Herrera.
I hereby release this source code for free distrubution and use.
If you modify it and distribute it, please indicate any changes you
make as your own and the code as copyrighted above.
**************************************************************************/
// file gcobject.hpp declaration of gcobject class.
// This base class does garbage collection.
// The function Allocate() is used instead of new().

#if !defined(GCOBJECT_HPP)
#define GCOBJECT_HPP 

#include <stddef.h>


extern const char handle_alloc_err[];
extern const char gcobject_alloc_err[];

struct data_record
{
	size_t alloc_length;	// size of this allocation.
	int ref_count;			// > 0 if allocated, == 0 if deleted.
	data_record ** owner_record; // pointer to owner's pointer to this.
	char data[1];		   // dummy address of allocated memory.
};

class gcobject
{
public:
	// constructor
	gcobject(size_t buf_size = 10000, int gci = 1000);

	// destructor
	~gcobject();

	// allocation function (garbage collected--no deallocator)
	void Allocate(size_t sz, data_record ** owner);

	// for incremental garbage collection
	void IncDeleteCount();

	// buffer locking and unlocking--need to have one unlock per lock.
	void Lock();
	void Unlock();

	// force complete collection of buffer if unlocked.
	void CompactBuffer();

#ifdef DEBUG
	void DumpBuffer();	// allows us to see what's in the buffer.
#endif

private:
	int lockcount;
	char * buffer_start;			// start of buffer used by Allocate().
	size_t buffer_size;				// size of buffer used by Allocate().
	size_t allocated_size;			// amount of buffer in use.
	int garbage_collection_interval;// destruct count prior to collection.
	int delete_count;				// incremented on destructor calls.
	int CollectGarbage();			// compacts the buffer.
};


#endif

// end of file gcobject.hpp
