// Program : FINDDEV.C
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : 04/26/93 10:23:56
// Note    : Copyright 1992-93, Eric Woodruff, All rights reserved
// Compiler: Borland C++ 3.1
//
// Walk the device driver chain looking for the specified device driver name.
// This is useful in AUTOEXEC.BAT for basing the execution of a set of
// commands on whether or not a device driver is loaded.  I wrote it to
// see if a network driver loaded successfully or not.
// Should work with DOS 2.x and up although I've only tested it on 3.x and up
// and DR DOS 6.0.
//
// Syntax:  FINDDEV /Nname /V
//          where "name" in /Nname is the device driver name to locate and
//          and /V is the optional verbose switch that will list names
//          as they are located.  If neither /N nor /V are used, the
//          default is to list all device driver names.
//
// Example FINDNAME.BAT
//  @ECHO OFF
//
//  REM %1 = /Nname where name is device name to find.
//  REM %2 = /V optional to list all names as they are found.
//  FINDDEV %1 %2
//  IF ERRORLEVEL 3 GOTO NOTFOUND
//  IF ERRORLEVEL 2 GOTO FOUND
//
//  ECHO Error in parameters: FINDDEV %1 %2
//  GOTO END
//
//  :FOUND
//  ECHO FINDDEV %1 %2 : Found
//  GOTO END
//
//  :NOTFOUND
//  ECHO FINDDEV %1 %2 : Not Found
//
//  :END
//

#include <ctype.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define  ERROR_EXIT     1
#define  FOUND_NAME     2
#define  NAME_NOT_FOUND 3

struct DeviceHeader {
    struct DeviceHeader far *NextDev;   // Points to next device driver header.
    short  Attribute;
    short  StrategyPtr;
    short  InterruptPtr;
    char   Name_Unit[8];
};

void main(int argc, char *argv[])
{
    struct DeviceHeader far *Device;
    char  DName[9], *SearchName = NULL, SearchText[9] = "";
    short Verbose = 0;

    while(--argc > 0)
        if(argv[argc][0] == '/' || argv[argc][0] == '-')
            switch(toupper(argv[argc][1]))
            {
                case 'N':
                    SearchName = &argv[argc][2];    // Name to find.
                    if(strlen(SearchName) > 8)
                    {
                        puts("Search name is greater than 8 characters");
                        exit(ERROR_EXIT);
                    }
                    // Pad with spaces to match device drive name format.
                    sprintf(SearchText, "%-8s", SearchName);
                    break;

                case 'V':
                    Verbose = 1;    // Print name as they are found.
                    break;

                default:
                    puts("Format: FINDDEV /Nname [/V]");
                    exit(ERROR_EXIT);
            }
        else
        {
            puts("Format: FINDDEV /Nname [/V]");
            exit(ERROR_EXIT);
        }

    if(!SearchName)
        Verbose = 1;        // No search name, list all devices found.

asm {
    mov     ax, 0x5200      // Get first device driver pointer.
    int     0x21
    cmp     _osmajor, 3     // DOS 3 or greater?
    jge     short Is30orUp
    add     bx, 0x17        // Point to first byte of device NUL:.
    jmp     short WalkList
    }

Is30orUp:

asm add     bx, 0x22        // It's a little further down for DOS 3.x and up.

WalkList:
asm {
    mov     word ptr &Device + 2, es        // Set first pointer.
    mov     word ptr &Device,     bx
    }

    // While not end of list (Segment = 0xFFFF), look for the device name.
    for( ; FP_SEG(Device) != 0xFFFF; Device = Device->NextDev)
    {
        // Device names are 8 character, space padded strings (NO NULL).
        // Drives are represented by their number as an ASCII character.
        if(Device->Name_Unit[0] < 32)
            sprintf(DName, "Drive %d", Device->Name_Unit[0]);
        else
#if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__)
            _fstrncpy((char far *)DName, Device->Name_Unit, 8);
#else
            strncpy(DName, Device->Name_Unit, 8);
#endif
        DName[8] = '\x0';

        if(Verbose)
            printf("%s\n", DName);

        if(!stricmp(SearchText, DName))
            exit(FOUND_NAME);       // Exit as soon as it is found.
    }
    exit(NAME_NOT_FOUND);       // Wasn't there.
}
