
//
// Turbo C++ 3.0
// Examples of Sorting.
// Written by Keith Harrison. 24 Oct 94.
//

#include <bios.h>
#include <iostream.h>
#include <stdlib.h>
#include <time.h>

const int SEED=1; // Starting point for random numbers.

int MAXELEMENTS;
int *array;

//Prototypes.
long gettime      (long baseline);
void setarray     (void);
void checkarray   (void);
void swap         (int *element1, int *element2);
void bubblesort   (void);
void exchangesort (void);
void shellsort    (void);

int main(void)
{
  cout << "\nHow many elements: ";
  cin  >> MAXELEMENTS;
  cout << "\n";

  if (!(array = new int [MAXELEMENTS])) // Dynamic allocation.
  {
    cout << "\n\nCould not allocate enough memory...\n\n";
    return 1;
  }

  for (int i=0; i<3; i++)
  {
    setarray();
    long starttime = gettime(0L);
    switch (i) {
      case 0: bubblesort()  ; break;
      case 1: exchangesort(); break;
      case 2: shellsort()   ; break;
    }
    long duration = gettime(starttime);
    cout << (float)duration/18.2 << " seconds\n";
    checkarray();
  }
  cout << "No prizes for guessing which one is best...!\n";
  return 0;
}

long gettime(long baseline)
{
  return (biostime(_TIME_GETCLOCK, 0) - baseline);
}

void setarray(void)
{
  srand(SEED); // Ensure same seed every time.
  for (int i=0; i<MAXELEMENTS; i++)
    array[i] = rand();
}

void checkarray(void)
{
  int errorcount=0;

  for (int i=1; i<MAXELEMENTS; i++)
    if (array[i-1] > array[i]) errorcount++;

  if (errorcount)
    cout << errorcount;
  else
    cout << "No";
  cout << " errors found in array.\n\n";
}

inline void swap(int *element1, int *element2)
{
  int temp = *element1;
  *element1 = *element2;
  *element2 = temp;
}

void bubblesort(void)
{
  cout << "BubbleSort    : ";

  int limit = MAXELEMENTS-1;
  int Switch; // Distinguish from C++ 'switch' keyword...
  do {
    Switch = -1;
    for (int row=0; row<limit; row++)
      if (array[row] > array[row+1])
      {
	swap(&array[row], &array[row+1]);
	Switch = row;
      }
    limit = Switch;
  } while (Switch != -1);
}

void exchangesort(void)
{
  cout << "Exchange sort : ";

  for (int row=0; row < MAXELEMENTS; row++)
  {
    int smallestrow = row;
    for (int j=row+1; j < MAXELEMENTS; j++)
      if (array[j] < array[smallestrow])
	smallestrow = j;
    if (smallestrow > row)
      swap(&array[row], &array[smallestrow]);
  }
}

void shellsort(void)
{
  cout << "Shell sort    : ";

  int Switch, limit, row;
  int offset = MAXELEMENTS / 2;

  while (offset > 0)  {
    limit = MAXELEMENTS - offset;
    do  {
      Switch = 0;
      for (row=1; row<(limit+1); row++)
	if (array[row-1] > array[row+offset-1]) {
	  swap (&array[row-1], &array[row+offset-1]);
	  Switch = row;
	}
      limit = Switch - offset;
    } while (Switch);
    offset >>= 1; // Faster than 'offset = offset / 2'
  }
}
