#include "fast32.h"
#include <stdio.h>

char line1[] = "This is a test of accessing the color video memory using the";
char line2[] = "standard DS data selector.";
int offset1 = 0, offset2 = 160;
char scrAttr = 0x4F;

void screenWrite(char* dest, const char* source);

int main()
{
   char* screen;

   printf("\n\n\nInitializing... ");
   if(!dpmi_setDsLimitToMax())
   {
      printf("**failed**\n");
      return 2;
   }

   screen = (char*) WRAPADDRESS(0xB8000UL);
   screenWrite(screen+offset1, line1);
   screenWrite(screen+offset2, line2);

   return 0;
}

void screenWrite(char* dest, const char* source)
{
   while(*source)
   {
      *dest++ = *source++;
      *dest++ = scrAttr;
   }
}

