#ifndef DEF_FAST32_H
#define DEF_FAST32_H

#ifndef __FLAT__
#error FAST32 requires DPMI32!
#endif

#ifdef __cplusplus
extern "C" {
#endif

// dpmi_ds_base is the base linear address for the DS register. It defaults
// to 0 (invalid) - you must call dpmi_setDsLimitToMax() to init it.
extern unsigned int dpmi_ds_base;

// dpmi_setDsLimitToMax() will set the limit for the DS selector to the max
// allowed (0xFFFFFFFFUL+1) and initialize dpmi_ds_base to the base linear
// address for the DS selector.
int dpmi_setDsLimitToMax(void);

// Will call dpmi_setDsLimitToMax() if necessary to initialize dpmi_ds_base
// and the DS selector; returns a wrapped linear address that allows using
// the DS registers to access the passed in real mode linear address.
unsigned int dpmi_wrapAddress(unsigned int);

// WRAPADDRESS() macro does no checking; it just wraps the linear address to
// one accessible via the DS selector. Using this offset without having called
// dpmi_setDsLimitToMax() is undefined, and will undoubtedly cause a GPF.
#define WRAPADDRESS(x)  ((unsigned int)(x) - dpmi_ds_base)

#ifdef __cplusplus
}
#endif

#endif   // DEF_FAST32_H
