#include <dos.h>

#ifndef __FLAT__
#error FAST32 requires DPMI32!
#endif

unsigned int dpmi_ds_base = 0;

int dpmi_setDsLimitToMax(void)
{
   union REGS regs;

   if(!dpmi_ds_base)
   {
      // First, get the base linear address for DS.
      regs.w.bx = _DS;
      regs.w.ax = 0x0006;
      int386(0x31, &regs, &regs);
      if(regs.x.cflag)
         return 0;
      dpmi_ds_base = ((unsigned int)(regs.w.cx) << 16) | regs.w.dx;

      regs.w.bx = _DS;
      regs.w.ax = 0x0008;
      regs.w.cx = regs.w.dx = 0xFFFF;
      int386(0x31, &regs, &regs);
      return !regs.x.cflag;
   }
   else
      return 1;
}

unsigned int dpmi_wrapAddress(unsigned int addr)
{
   if(!dpmi_ds_base && !dpmi_setDsLimitToMax())
      return 0;
   return addr-dpmi_ds_base;
}

