/*******************************************************************************
** OUTBUFF - OutputBuffer class
** Created 5/25/95 by John Stockton
** CIS: 76041,2534
** INTERNET: jstockton%inova@mcimail.com
**
** Copyright (c) 1995 INOVA Corporation.  May be copied, used and distributed, 
** as long as no charge is made for its use and this copyright notice is not
** altered or removed.
**
** $Header: j:/library/express/rcs/outbuff.hpp 1.4 1995/06/29 15:08:47 JOHN Exp $
*******************************************************************************/

#if !defined( OUTBUFF_HPP)
#define OUTBUFF_HPP

#include <classlib\arrays.h>

class OutputBuffer
{
public:
   OutputBuffer( void);
   ~OutputBuffer( void);
      // Constructor & destructor
   inline OutputBuffer &operator<<( BYTE);
      // Puts the given byte into the buffer
   OutputBuffer &operator<<( const char *);
      // Puts the contents of the given string into this OutputBuffer (including
      // the null terminator)
   OutputBuffer &operator<<( const OutputBuffer &);
      // Puts the contents ot the given OutputBuffer into this OutputBuffer
   operator const BYTE *( void);
      // Converts this buffer into a contiguous chunk of bytes (use GetSize() to
      // determine its size; do NOT delete this buffer: it will be deleted when
      // this OutputBuffer is destroyed!  This function freezes the buffer: subsequent
      // attempts to add to it will be rejected.)
   inline unsigned GetSize( void) const;
      // Returns the size of the buffer
   inline BOOL IsFrozen( void);
      // Returns true if the buffer is frozen
   void Reset( void);
      // Deletes the contents of the buffer and "un-freezes" it, if frozen

private:
   TArrayAsVector<BYTE> aBuffer;
      // Dynamic array
   BYTE *pBuffer;
      // Static buffer (allocated and filled by operator const BYTE *)
};

// Provide stream operators to put any flat type into a OutputBuffer
template <class T> OutputBuffer &operator<<( OutputBuffer &cb, T t)
{
   for (size_t i = 0; i < sizeof( T); i++)
      cb << ((BYTE * ) &t)[i];

   return cb;
}

#endif // #if !defined( OUTBUFF_HPP)

