/*******************************************************************************
** EXPVAR - ExpVariable class
** Created 5/16/95 by John Stockton 
** CIS: 76041,2534
** INTERNET: jstockton%inova@mcimail.com
**
** Copyright (c) 1995 INOVA Corporation.  May be copied, used and distributed, 
** as long as no charge is made for its use and this copyright notice is not
** altered or removed.
**
** $Header: j:/library/express/rcs/expvar.cpp 1.4 1995/06/29 15:08:25 JOHN Exp $
*******************************************************************************/

#include "express.hpp"
#include <assert.h>
#include <string.h>

/*******************************************************************************
** Public members
*******************************************************************************/

ExpVariable::ExpVariable(
      const char *_szName,
      ExpElement::eEvalTypes _eEvalType,
      const char *_szDescription,
      UINT16 _nFieldNumber) :
      ExpElement( ExpElement::ExpVARIABLE, _eEvalType),
      szName( strdup( _szName)),
      szDescription( 0),
      nFieldNumber( _nFieldNumber)
{
   assert( this->szName);
   if (_szDescription)
      this->szDescription = strdup( _szDescription);
}


ExpVariable::ExpVariable( const ExpVariable &_v) :
      ExpElement( _v.GetElementType(), _v.GetEvalType()),
      szName( strdup( _v.szName)),
      szDescription( 0),
      nFieldNumber( _v.nFieldNumber)
{
   if (_v.szDescription)
      this->szDescription = strdup( _v.szDescription);
}


ExpVariable::~ExpVariable( void)
{
   delete this->szName;
   delete this->szDescription;
}


#if !defined( EXPRESS_NO_IOSTREAM)
void ExpVariable::Output( ostream &_os) const
{
   if (this->szDescription)
      _os << this->szDescription;
   else
      _os << this->szName;
}


ostream &operator<<( ostream &_os, const ExpVariable &_v)
{
   _v.Output( _os);

   return _os;
}
#endif


/******************************************************************************
** IDAPI CANExpr conversion
******************************************************************************/

#if !defined( EXPRESS_NO_IDAPI)
void ExpVariable::BuildCANBuffers(
      OutputBuffer &_bufNode,
      OutputBuffer &_bufLiteral,
      UINT16 &_nNodes,
      UINT16 &_nNodeOffset,
      UINT16 &_nLiteralOffset)
{
   CANField canField;
   canField.nodeClass = nodeFIELD;
   canField.canOp = canFIELD;
   canField.iFieldNum = this->nFieldNumber;
   canField.iNameOffset = _nLiteralOffset;

   _bufNode << canField;
   _bufLiteral << this->szName;

   _nNodes++;
   _nNodeOffset += (UINT16) _bufNode.GetSize();
   _nLiteralOffset += (UINT16) _bufLiteral.GetSize();
}
#endif
