/*
        pedigree.h -- polymorphic cluster typing
        (C) Copyright 1996  John Webster Small
        All rights reserved
*/

#ifndef pedigree_h
#define pedigree_h

/* LINTLIBRARY */

#ifndef typeinfo_h
  #include <typeinfo.h>
  #ifndef typeinfo_h
    #define typeinfo_h
  #endif
#endif

#ifndef cstr_h
  #include "cstr.h"
#endif

#define PEDIGREE_DERIVED_COMMON(DERIVED) \
  private: \
    int _cmpTypes(const char * typeid_name_) const \
    { \
        if (typeid_name_) \
            return  strcmp(typeid(DERIVED).name(), \
                typeid_name_); \
        return 1; \
    } \
  public: \
    virtual cstr& typeid_name(cstr& cs) const \
        { return cs.cpy(typeid(DERIVED).name()); } \
    virtual size_t sizeofType() { return sizeof(DERIVED); } \
    virtual int isA(const char * typeid_name_) const \
      { return !_cmpTypes(typeid_name_); } \
    virtual int isKindOf(const char * typeid_name_) const
#define PEDIGREE_DERIVED(DERIVED,BASE) \
    PEDIGREE_DERIVED_COMMON(DERIVED) \
      { return (!_cmpTypes(typeid_name_)? 1 \
        : BASE::isKindOf(typeid_name_)); }
#define PEDIGREE_DERIVED_MULTI(DERIVED) \
    PEDIGREE_DERIVED_COMMON(DERIVED);

#define PEDIGREE_MULTI_DEF_BEGIN(DERIVED) \
int DERIVED::isKindOf(const char * typeid_name_) const \
{ \
    if (!_cmpTypes(typeid_name_)) return 1;
#define PEDIGREE_MULTI_BASE(BASE) \
    if (BASE::isKindOf(typeid_name_)) return 1;
#define PEDIGREE_MULTI_DEF_END \
    return 0; }

class Pedigree
{
    int _cmpTypes(const char * typeid_name_) const
    {
        if (typeid_name_)
            return  strcmp(typeid(Pedigree).name(),
                typeid_name_);
        return 1;
    }
  public:
    Pedigree() {}
    virtual ~Pedigree() {}
    virtual cstr& typeid_name(cstr& cs) const
        { return cs.cpy(typeid(Pedigree).name()); }
    virtual size_t sizeofType()
        { return sizeof(Pedigree); }
    virtual int isA(const char * typeid_name_) const
      { return !_cmpTypes(typeid_name_); }
    virtual int isKindOf(const char * typeid_name_) const
      { return !_cmpTypes(typeid_name_); }
    int cmpTypes(const Pedigree& p) const
    { 
        cstr cs;
        return _cmpTypes(p.typeid_name(cs));
    }
};

#endif
