

#include <owl\owlpch.h>
#pragma hdrstop

#include <stdio.h>
#include "test.rh"
#include "enabledl.h"

class TTestMDIClient : public TMDIClient
{
	public:
	TTestMDIClient() : TMDIClient() {}

	MIXIN_CLIENT_ENABLE_FUNCS;

	void CmFileNew();
	void CmTest();
	void CmTestModal();
	DECLARE_RESPONSE_TABLE(TTestMDIClient);
};

DEFINE_RESPONSE_TABLE1(TTestMDIClient, TMDIClient)
	 EV_COMMAND(CM_FILENEW,CmFileNew),
	 EV_COMMAND(CM_TEST_DIALOG,CmTest),
	 EV_COMMAND(CM_TEST_MODAL_DIALOG,CmTestModal),
END_RESPONSE_TABLE;


class TestApp : public TApplication
{
	public:
	TestApp() : TApplication() {}
	void InitMainWindow();

};

TStatusBar *sb = NULL;

void TestApp::InitMainWindow()
{
	TDecoratedMDIFrame *frame = new TDecoratedMDIFrame("Test Enabler/Balloon Help",MENU_1,*new TTestMDIClient());
	frame->Attr.AccelTable = MENU_1;

	sb = new TStatusBar(frame, TGadget::Recessed,
									TStatusBar::CapsLock        |
									TStatusBar::NumLock         |
									TStatusBar::ScrollLock      |
									TStatusBar::Overtype);
	frame->Insert(*sb, TDecoratedFrame::Bottom);

	SetMainWindow(frame);
	EnableCtl3d();
};

int OwlMain (int , char* [])
{
	TestApp     App;
	int    result;

    result = App.Run();

    return result;
}


//*****************************************************************************
// Test Dialog Stuff
static string lasttext = "";

class TTestDialog : public TDialog, public TMixInEnableDialog {
public:
	TTestDialog (TWindow* parent, TResId resId = IDD_TEST, TModule* module = 0);
	virtual ~TTestDialog ();

	enum TEHelpDisplay
	{
		Normal,Status,Alternate
	};
	TEHelpDisplay	HelpDisplay;

	BOOL HandleHelp(TControlHelpData *hd)
	{
		if (HelpDisplay != Alternate)
			return FALSE;

		if (! hd)
		{
			lasttext = "";
			((TTextGadget *)(*sb)[0])->SetText("");
		}
		else if (hd->text != lasttext)
		{
			((TTextGadget *)(*sb)[0])->SetText(hd->text.c_str());
			lasttext = hd->text;
		}
		return TRUE;
	}

protected:
	void helpOnClicked ();
	void balloonColorClicked ();
	void balloonDisplayClicked ();

	DECLARE_RESPONSE_TABLE(TTestDialog);
   	MIXIN_ENABLE_FUNCS;


	void CeHelpOn(TCommandEnabler& ce);
	void CeBalloonColor(TCommandEnabler& ce);
	void CeOk(TCommandEnabler& ce);
	void CeCancel(TCommandEnabler& ce);
	void CeAmount(TCommandEnabler& ce);
	void CeRevAmount(TCommandEnabler& ce);
	void CeGoAway(TCommandEnabler& ce);
	void CeChase(TCommandEnabler& ce);
	void CeHelpDisplayNormal(TCommandEnabler& ce);
	void CeHelpDisplayStatus(TCommandEnabler& ce);
	void CeHelpDisplayAlt(TCommandEnabler& ce);
};    //{{TTestDialog}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE2(TTestDialog, TMixInEnableDialog,TDialog)
	EV_BN_CLICKED(IDC_HELPON, helpOnClicked),
	EV_BN_CLICKED(IDC_BCOLOR, balloonColorClicked),
	EV_BN_CLICKED(IDC_BNORMAL, balloonDisplayClicked),
	EV_BN_CLICKED(IDC_BALT, balloonDisplayClicked),
	EV_BN_CLICKED(IDC_BSTATUS, balloonDisplayClicked),
	EV_CONTROL_ENABLE(IDC_HELPON,CeHelpOn),
	EV_CONTROL_ENABLE(IDC_BCOLOR,CeBalloonColor),
	EV_CONTROL_ENABLE(IDOK,CeOk),
	EV_CONTROL_ENABLE(IDCANCEL,CeCancel),
	EV_CONTROL_ENABLE(IDC_AMOUNT,CeAmount),
	EV_CONTROL_ENABLE(IDC_AMOUNTDESC,CeAmount),
	EV_CONTROL_ENABLE(IDC_REVAMOUNT,CeRevAmount),
	EV_CONTROL_ENABLE(IDC_GOAWAY,CeGoAway),
	EV_CONTROL_ENABLE(IDC_CHASE,CeChase),

	EV_CONTROL_ENABLE(IDC_BNORMAL,CeHelpDisplayNormal),
	EV_CONTROL_ENABLE(IDC_BNORMAL,CeHelpDisplayStatus),
	EV_CONTROL_ENABLE(IDC_BNORMAL,CeHelpDisplayAlt),
END_RESPONSE_TABLE;


//{{TTestDialog Implementation}}


TTestDialog::TTestDialog (TWindow* parent, TResId resId, TModule* module):
	TDialog(parent, resId, module),HelpDisplay(Normal)
{
	// INSERT>> Your constructor code here.
	// NOTE : We have added auto word breaking to the balloon help
	//		  You can still force a line break with \r\n
	AddHelp(IDOK,
		"Ok\r\nYou cannot press this until 'Enable Ok' is checked and "\
		"Amount is filled in");
	AddHelp(IDCANCEL,"Cancel Button");
	AddHelp(IDC_AMOUNT,"Enter Amount");
	AddHelp(IDC_AMOUNTDESC,"This uses the same enabler func as amount edit");
	AddHelp(IDC_ENABLEAMOUNT,"Enables Amount Data Entry");
	AddHelp(IDHELP,"This is a really really really really long line");
	AddHelp(IDC_HELPON,
		"This illustrates using the command enablers to "\
		"perform auto setting of a check according to a program variable");
	AddHelp(IDC_GOAWAY,"Heh heh, Thought you could press this didn't you...");

	AddDisabledHelp(IDC_AMOUNT,"Check \"Enable Amount\" checkbox first");
	AddDisabledHelp(IDCANCEL,"Check \"Enable Cancel\" checkbox first");

	// Size Stuff
	AddSize(IDC_GOAWAY,AnchorRight);
	AddSize(IDOK,AnchorDown | AnchorHorizCenter);
	AddSize(IDCANCEL,AnchorDown | AnchorHorizCenter);
	AddSize(IDHELP,AnchorDown | AnchorHorizCenter);

	AddSize(109,GrowRight);
	AddSize(IDC_AMOUNT,GrowRight | GrowDown);

	AddSize(IDC_EDIT3,AnchorDown | AnchorHorizPercent | GrowLeftOf);
	AddSize(IDC_EDIT2,AnchorDown | AnchorHorizPercent | GrowLeftOf,IDC_EDIT3);
	AddSize(IDC_EDIT1,AnchorDown | GrowLeftOf,IDC_EDIT2);

	AddSize(403,AnchorDown | AnchorRight,IDC_EDIT3);
	AddSize(402,AnchorDown | AnchorRight,IDC_EDIT2);
	AddSize(401,AnchorDown | AnchorRight,IDC_EDIT1);

	AddHelp(IDC_EDIT3,
		"AnchorDown     	- relative to Dialog Bottom\r\n"
		"AnchorHorizPercent	- Left side set to a percentage of Dialog Width\r\n"
		"GrowLeftOf         - Right side set absolutley relative to Dialog RHS");
	AddHelp(IDC_EDIT2,
		"AnchorDown             - relative to Dialog Bottom\r\n"
		"AnchorHorizPercent 	- Left side set to a percentage of Dialog Width\r\n"
		"GrowLeftOf,IDC_EDIT3	- Right side set absolutley relative to IDC_EDIT3 LHS");
	AddHelp(IDC_EDIT1,
		"AnchorDown 			- relative to Dialog Bottom\r\n"
		"GrowLeftOf,IDC_EDIT2	- Right side set absolutley relative to IDC_EDIT2 LHS");

	BHelp::SetTabStops(4);
}


TTestDialog::~TTestDialog ()
{
	Destroy();
	// INSERT>> Your destructor code here.

}


void TTestDialog::helpOnClicked ()
{
	// INSERT>> Your code here.
	BHelp::On(!BHelp::On());
}

void TTestDialog::balloonColorClicked ()
{
	// cycle through colors
	if (BHelp::BkColor() == TColor::LtYellow)
	{
		BHelp::BkColor(TColor::LtCyan);
		BHelp::TextColor(TColor::LtBlue);
	}
	else if (BHelp::BkColor() == TColor::LtCyan)
	{
		BHelp::BkColor(TColor::LtGray);
		BHelp::TextColor(TColor::Black);
	}
	else
	{
		BHelp::BkColor(TColor::LtYellow);
		BHelp::TextColor(TColor::Black);
	};
}

void TTestDialog::CeBalloonColor(TCommandEnabler& ce)
{
	ce.Enable(TRUE);
	if (BHelp::BkColor() == TColor::LtYellow)
		ce.SetText("Default");
	else if (BHelp::BkColor() == TColor::LtCyan)
		ce.SetText("Blue/Cyan");
	else
		ce.SetText("Black/LtGray");
};

void TTestDialog::CeHelpOn(TCommandEnabler& ce)
{
	ce.SetCheck(BHelp::On());
};

void TTestDialog::CeOk(TCommandEnabler& ce)
{
	BOOL check_enable 	= IsDlgButtonChecked(IDC_ENABLEOK);
	BOOL amount_enable 	= ::GetWindowTextLength(GetDlgItem(IDC_AMOUNT)) > 0;

	string dhelp = "";
	if (!check_enable)
		dhelp += "Check the \"Enable Ok\" checkbox";
	if (!amount_enable)
	{
		if (! dhelp.is_null())
			dhelp += "\r\nand ";
		dhelp += "Enter amount";
	};
	if (! (check_enable && amount_enable))
		AddDisabledHelp(IDOK,dhelp.c_str());
	else
		RemoveDisabledHelp(IDOK);

	ce.Enable(check_enable && amount_enable);
};

void TTestDialog::CeCancel(TCommandEnabler& ce)
{
	BOOL enable = IsDlgButtonChecked(IDC_ENABLECANCEL);
	ce.Enable(enable);
	ce.SetText(::GetWindowTextLength(GetDlgItem(IDC_AMOUNT)) > 0 ? "Close" : "Cancel");
};

void TTestDialog::CeAmount(TCommandEnabler& ce)
{
	BOOL enable = IsDlgButtonChecked(IDC_ENABLEAMOUNT);
	ce.Enable(enable);
};

void TTestDialog::CeRevAmount(TCommandEnabler& ce)
{
	if (IsDlgButtonChecked(IDC_ENABLEAMOUNT))
		CheckDlgButton(IDC_REVAMOUNT,0);
	else
		CheckDlgButton(IDC_REVAMOUNT,1);
};

void TTestDialog::CeGoAway(TCommandEnabler& ce)
{
	TRect r;
	::GetWindowRect(GetDlgItem(IDC_GOAWAY),&r);
	TPoint p;
	GetCursorPos(p);

	if (r.Contains(p))
	{
		ce.Enable(FALSE);
		ce.SetText("Go away!");
	}
	else
	{
		ce.Enable(TRUE);
		ce.SetText("Click Me!");
	}
};

void TTestDialog::CeChase(TCommandEnabler& ce)
{
	ce.Enable(TRUE);

	HWND hwnd = GetDlgItem(IDC_CHASE);
	if (!hwnd)
		return;

	TPoint p;
	GetCursorPos(p);

	TRect r;
	::GetWindowRect(hwnd,&r);


	if (r.Contains(p))
	{
		ScreenToClient(p);
		TPoint tl = r.TopLeft();
		TPoint br = r.BottomRight();
		ScreenToClient(tl);
		ScreenToClient(br);
		r = TRect(tl,br);

		if (p.x >= r.left && p.x <= r.left + r.Width() / 4)
			r.Offset(2,0);
		else if (p.x > r.left  + r.Width() / 4 * 3)
			r.Offset(-2,0);

		if (p.y >= r.top && p.y <= r.top + r.Height() / 2)
			r.Offset(0,2);
		else if (p.y > r.top  + r.Height() / 4 * 3)
			r.Offset(0,-2);

		::MoveWindow(hwnd,r.left,r.top,r.Width(),r.Height(),TRUE);
		::InvalidateRect(hwnd,&TRect(0,0,r.Width(),r.Height()),TRUE);
	};
};

void TTestDialog::balloonDisplayClicked ()
{
	if (IsDlgButtonChecked(IDC_BNORMAL))
	{
		HelpDisplay = Normal;
		BHelp::UseStatusBar(NULL);
	}
	if (IsDlgButtonChecked(IDC_BSTATUS))
	{
		HelpDisplay = Status;
		BHelp::UseStatusBar(sb);
	}
	if (IsDlgButtonChecked(IDC_BALT))
	{
		HelpDisplay = Alternate;
		BHelp::UseStatusBar(NULL);
	}
};

void TTestDialog::CeHelpDisplayNormal(TCommandEnabler& ce)
{
	ce.SetCheck(HelpDisplay == Normal);
};

void TTestDialog::CeHelpDisplayStatus(TCommandEnabler& ce)
{
	ce.SetCheck(HelpDisplay == Status);
};

void TTestDialog::CeHelpDisplayAlt(TCommandEnabler& ce)
{
	ce.SetCheck(HelpDisplay == Alternate);
};

void TTestMDIClient::CmTest()
{
	TMDIChild * child = new TMDIChild(*this,"Test Modeless Dialog",new TTestDialog(NULL),TRUE);
	child->Create();
};

void TTestMDIClient::CmTestModal()
{
	TTestDialog dlg(this,IDD_TEST_MODAL);
	dlg.Execute();
};


// ignore this, it is soley for my testing/debugging purposes

void FillList(TWindow* p, void*param)
{
	TListBox *lb = (TListBox *) param;
	if (!lb || !p)
		return;

	char text[256];
	char cname[256];
	char buffer[256];
	p->GetWindowText(text,sizeof(text));
	GetClassName(p->HWindow,cname,sizeof(cname));
	sprintf(buffer,"%s : %s",cname,text);
	lb->AddString(buffer);
}


void TTestMDIClient::CmFileNew()
{

	TListBox *lb = new TListBox(NULL,100,0,0,0,0);
	TMDIChild * child = new TMDIChild(*this,"Client Child List",lb);
	child->Create();

	ForEach(FillList,lb);
};




