#ifndef __ENABLEDL_H
#define __ENABLEDL_H

#include <owl\statusba.h>
//**************************************
// Help Settings

class BHelp
{
	public:
	enum Style
	{
		SquareBorder	= 0x00,
		Shadow			= 0x02,
	};

	static Style style;
	static BYTE tabstops;

	inline static BHelp::Style  SetStyle()						{return style;}
	inline static BHelp::Style  SetStyle(BHelp::Style setto)	{style = setto;return style;}
	inline static BYTE SetTabStops()   			{return tabstops;}
	inline static BYTE SetTabStops(BYTE setto)	{tabstops = setto;return tabstops;}

	public:

	static inline BOOL		On();
	static 		  BOOL		On(BOOL setto);
	static 		  TColor	BkColor();
	static 	   	  TColor	TextColor();
	static 		  TColor	BkColor(TColor setto);
	static 		  TColor	TextColor(TColor setto);
    static		  void		UseStatusBar(TStatusBar *sb = NULL);
};

//*********************************
// Disabled Help Settings
class DBHelp
{
	public:
	static inline BOOL		On();
	static 		  BOOL		On(BOOL setto);
	static 		  TColor	BkColor();
	static 	   	  TColor	TextColor();
	static 		  TColor	BkColor(TColor setto);
	static 		  TColor	TextColor(TColor setto);
};



#include <classlib\arrays.h>
#include <cstring.h>

// define EV_CONTROL_ENABLE
// Usage is _exactly_ the same as EV_COMMAND_ENABLE
// but doing this prevents a modeless dialog gobbling the
// WM_COMMAND messages generated by men
// Plus it is a little more decriptive of what it is actually doing
// Note that WM_CONTROL_ENABLE messages are only sent to the child windows
// in a dialog, unlike WM_COMMAND_ENABLE which are propagated throught the whole
// window tree

template <class T>
inline void(T::*v_CONTROLENABLER_Sig(void(T::*pmf)(TCommandEnabler&)))(TCommandEnabler&)
{
  return pmf;
}

// Better hope this is not used by anything else...
#define WM_CONTROL_ENABLE	(WM_VBXBASE - 2)

//
// handler for Control enabling
//  void method(UINT controlId)
//
#define EV_CONTROL_ENABLE(id, method)\
  {WM_CONTROL_ENABLE, id, (TAnyDispatcher)::v_POINTER_Dispatch,\
   (TMyPMF)v_CONTROLENABLER_Sig(&TMyClass::method)}


//*********
//
//	Class:TControlHelpData
//
// 	Description:
//	Support class for managing balloon help data
//
//  Last modified date:9/5/95
//  Last modified by:Lindsay Mathieson
//

class TControlHelpData
{
	public:
	int		Id;
	string	text;

	TControlHelpData() : Id(-1), text("") {}
	TControlHelpData(int id, string s) : Id(id), text(s) {}
	~TControlHelpData()	{}

	void Set(string s)
	{
		text = s;
	};

	int operator == (const TControlHelpData& d)	{return Id == d.Id;}
	int operator <  (const TControlHelpData& d)	{return Id <  d.Id;}
};


//
//  Class:TBHelpData
//
//  Description:
//	Maintains list of help data for controls
//
//  Last modified date:4/5/95
//  Last modified by:Lindsay Mathieson
//

class TBHelpData
{
	public:
	TISArrayAsVector<TControlHelpData>	Help;

	TBHelpData()	: Help(0,0,1) {Help.OwnsElements(1);}

	inline	int nHelp()	{return Help.GetItemsInContainer();}

	inline TControlHelpData *FindHelp(int id)
	{
		TControlHelpData tmp(id,"");
		int idx = Help.Find(&tmp);
		return (idx == INT_MAX) ? NULL : Help[idx];
	};

	void AddHelp(int id,string text)
	{
		TControlHelpData *data = FindHelp(id);
		if (data)
			data->Set(text);
		else
		{
			data = new TControlHelpData(id,text);
			Help.Add(data);
		};
	};

	void RemoveHelp(int id)
	{
		TControlHelpData *data = FindHelp(id);

		if (data)
			Help.Destroy(data);
	};
};

//
//	Class:TControlSizeData
//
// 	Description:
//	Support class for managing auto sizing/placement of controls
//
//  Last modified date:5/5/95
//  Last modified by:Lindsay Mathieson
//

enum TControlSizeEnum
{
	AnchorDown 				= 1,	// Anchor top relative to Dialog bottom
									//		- if another control, is relative to cntls top
	AnchorRight 			= 2,	// Anchor LHS relative to Dialog RHS
									//		- if another control, is relative to cntls LHS
	GrowDown 				= 4,
	GrowRight 				= 8,
	AnchorVertCenter 		= 16,	// Anchor relative to the center of the horiz axis
	AnchorHorizCenter 		= 32,	// Anchor relative to the center of the vert axis
	AnchorHorizPercent 		= 64,	// Anchor on the Horiz Axis on a percentage basis
	AnchorVertPercent 		= 128,  // Anchor on the Vertical Axis on a percentage basis
	GrowHorizPercent 		= 256,	// Grow on the Horiz Axis on a percentage basis
	GrowVertPercent 		= 512,	// Grow on the Vertical Axis on a percentage basis
	LeftOf					= 1024,	// LayoutWindow territory!
									// 		- relative to nominated control Lhs
	RightOf					= 2048,	// 		- relative to nominated control Rhs
	GrowLeftOf				= 4096	// adjusts right side relative to nominated control Lhs
									//      - null control means parent dialog

};

class TControlSizeData
{
	public:
	int		Id;
	DWORD	Options;
	HWND	hwnd;

	// following data interpreation depends on Options
    // making these long, allows integer arithmatic for the percentages
	long		x,y;
	long		cx,cy;
	int			RelId;

	TControlSizeData() :
		Id(-1), Options(0), hwnd(NULL),
		x(0),y(0),
		cx(0),cy(0),
		RelId (-1)
		{}
	TControlSizeData(int id, DWORD opt, int relId = -1) :
		Id(id), Options(opt), hwnd(NULL),
		x(0),y(0),
		cx(0),cy(0),
		RelId (relId)
		{}
	~TControlSizeData()	{}

	void Set(DWORD opt)
	{
		Options = opt;
	};

	int operator == (const TControlSizeData& d)	{return Id == d.Id;}
	int operator <  (const TControlSizeData& d)	{return Id <  d.Id;}
};


//
//  Class:TSizeData
//
//  Description:
//	Maintains list of auto size/placement data for controls
//
//  Last modified date:5/5/95
//  Last modified by:Lindsay Mathieson
//

class TSizeData
{
	public:
	TIArrayAsVector<TControlSizeData>	SizeList;

	TSizeData()	: SizeList(0,0,1) {SizeList.OwnsElements(1);}


	inline TControlSizeData *FindSize(int id)
	{
		TControlSizeData tmp(id,0);
		int idx = SizeList.Find(&tmp);
		return (idx == INT_MAX) ? NULL : SizeList[idx];
	};

	void AddSize(int id,DWORD opt, int relId = -1)
	{
		TControlSizeData *data = FindSize(id);
		if (data)
			data->Set(opt);
		else
		{
			data = new TControlSizeData(id,opt,relId);
			SizeList.Add(data);
		};
	};
};



//
// 	Class:TMixInEnableDialog
//
//  Description:
//	Addes idle/command enabling/ballon help to
//	existing dialog classes
//	Add the class to the dialog base inheritance
//	and the macro MIXIN_ENABLE_FUNCS for some overridden
//	funcs.
//	if you need to use these funcs then declare them yourself,
//	Just rember to also call the TMixInEnableDialog ones
//
//	See TEnableDialog (below) for a example
//
//   Last modified date:4/5/1995
//   Last modified by:Lindsay Mathieson
//
class TMixInEnableDialog : public virtual TWindow
{
	private:
	static BOOL modalActive;
	BOOL executingModally;
	HWND* wnds;

    protected:
	TBHelpData	BHelp;
	TSizeData	Size;
	TBHelpData	DBHelp;	// Help for disabled controls (i.e. why)

	void SizeInit();
	void EvSize(UINT sizeType, TSize& size);
	virtual LRESULT WindowProc(UINT msg, WPARAM wParam, LPARAM lParam);

	public:
	TMixInEnableDialog();
	~TMixInEnableDialog();
	virtual int 	ExecuteModally();
	virtual void 	DoDestroy(int retValue = IDCANCEL);
	virtual void 	DoCloseWindow(int retValue = IDCANCEL);
	virtual BOOL 	DoIdleAction(long idleCount);

	// Balloon Help Stuff
	inline void AddHelp(int id, string text)		{BHelp.AddHelp(id,text);}
	inline void RemoveHelp(int id)					{BHelp.RemoveHelp(id);}
	virtual BOOL HandleHelp(TControlHelpData *hd = NULL)
													{return FALSE;}
	void RemoveHelpWindow();


	// Size Stuff
	inline void AddSize(int id, DWORD opt, int relId = -1)	{Size.AddSize(id,opt,relId);}

	// Disabled Help Stuff
	inline void AddDisabledHelp(int id, string text)	{DBHelp.AddHelp(id,text);}
	inline void RemoveDisabledHelp(int id)				{DBHelp.RemoveHelp(id);}

    protected:
	void EvLButtonDown(UINT modKeys, TPoint& point);
};

// Must be added to TMDIClient class if MDI
// so that idle messages get sent to child windows
#define MIXIN_CLIENT_ENABLE_FUNCS \
	inline static void DoChildIdleAction(TWindow *child,void* idleCount)\
	{\
		child->IdleAction(*(long *)idleCount);\
	};\
	inline virtual BOOL IdleAction(long IdleCount)\
	{\
		ForEach(DoChildIdleAction ,(void *) &IdleCount);\
		return FALSE;\
	}

#define MIXIN_ENABLE_FUNCS \
	virtual int Execute()								{return ExecuteModally();}\
	virtual void Destroy(int retValue = IDCANCEL) 		{DoDestroy(retValue);}\
	virtual void CloseWindow(int retValue = IDCANCEL)	{DoCloseWindow(retValue);}\
	virtual BOOL IdleAction(long idleCount)				{return DoIdleAction(idleCount);}




//
//  Class:
//
//  Description:TEnableDialog
//	Dialog you can use as a base for new dialogs
//	So no need to add TMixInEnableDialog
//
//  Last modified date:4/5/95
//  Last modified by:Lindsay Mathieson
//
class TEnableDialog : public TDialog, public TMixInEnableDialog
{
	public:
	TEnableDialog(TWindow* parent, TResId resId, TModule* module = 0) :
		TDialog(parent,resId,module)
	{}

	MIXIN_ENABLE_FUNCS;
};



#endif
