
#include <owl\owlpch.h>
#pragma hdrstop
#include "enabledl.h"

#ifndef MAKEWORD
	#define MAKEWORD(a, b)      ((WORD)(((BYTE)(a)) | (((WORD)((BYTE)(b))) << 8)))
#endif

//*********************************************
// TControlEnabler
//
//	Class:TControlEnabler
//
//  Description:
//	Handles Dialog Control Enabling via WM_CONTROL_ENABLE messages
//                                      =================
//
//   Last modified date:9/5/95
//   Last modified by:Lindsay Mathieson
//
class TControlEnabler : public TCommandEnabler
{
	public:
	TControlEnabler(HWND cntrl, HWND hwndReceiver) :
		TCommandEnabler(GetWindowWord(cntrl,GWW_ID),hwndReceiver),
		Cntrl(cntrl)
	{
	};

	virtual void Enable(BOOL enable);
	virtual void SetText(const char far *str);
	virtual void SetCheck(int check);

	protected:
		HWND Cntrl;
};


void TControlEnabler::Enable(BOOL enable)
{
	TCommandEnabler::Enable(enable);
	EnableWindow(Cntrl,enable);
};

void TControlEnabler::SetText(const char far *str)
{
	int length = GetWindowTextLength(Cntrl) + 1;
	if (length < 0 || length > INT_MAX - 2)
    	return;
	char *text = new char[length];
	GetWindowText(Cntrl,text,length);
	if (strcmp(str,text))
		SetWindowText(Cntrl,str);
	delete [] text;
};

void TControlEnabler::SetCheck(int check)
{
	CheckDlgButton(HWndReceiver,Id,check);
};

//*********************************************************************
// Help Window Stuff
//
// 	Class:THelpWindow
//
//  Description:
//	Pops up in relative to a control & displays help
//	Automatically sizes & positions itself
//
//   Last modified date:
//   Last modified by:
//


class THelpWindow : public TWindow
{
	private:
	TControlHelpData	*Help;
	HWND				Child;
	BOOL				IsDHelp;

	public:
	inline int HelpId()	{return ((Help) ? Help->Id : -1);}

	THelpWindow(TWindow *parent,TControlHelpData *help,HWND child,BOOL isDHelp = FALSE);
	virtual void Destroy(int retVal = 0);
	~THelpWindow();



	void GetWindowClass(WNDCLASS& wndClass)
	{
		TWindow::GetWindowClass(wndClass);
		wndClass.style |= CS_SAVEBITS;
	};

	void SetupWindow();
	virtual void Paint(TDC& dc, BOOL erase, TRect& rect);

	void EvTimer(UINT timerId);
	DECLARE_RESPONSE_TABLE(THelpWindow);
};

static THelpWindow *HelpWindow = NULL;
static HWND	lastControl = NULL;
static TStatusBar *
				theStatusBar = NULL;
static string lasthinttext = "";

//***************************************************************
// 	Class:TMixInEnableDialog
//
//  Description:
//
//  Last modified date:
//  Last modified by:
//

//
// Structure for holding windows to disable
//
struct TEnumInfo {
  short     Count;
  HWND far* Wnds;
};
//
// Simplified from TApplication::DisableWnds
//
// Note this is called before the dialog is created and does not
// disable the windows
//
// Firstly called to count up the windows to be stored
// then called to save the windows
//
BOOL far _export _pascal EnumerateActiveWnds(HWND wnd, TEnumInfo* info)
{
	if (!(::GetWindowLong(wnd, GWL_STYLE) & WS_CHILD))
	{
		if (::IsWindowEnabled(wnd))
			if (!info->Wnds) // counting windows to determine buffer size
				info->Count++;
			else
				*(info->Wnds++) = wnd;
	}
	return TRUE;
}

BOOL TMixInEnableDialog::modalActive = FALSE;

TMixInEnableDialog::TMixInEnableDialog() :
	executingModally(FALSE),wnds(NULL)
{
	if (TYPESAFE_DOWNCAST(Parent,TMDIClient))
		SetParent(GetApplication()->GetMainWindow());

	//Attr.Style &= ~WS_VISIBLE;
};

TMixInEnableDialog::~TMixInEnableDialog()
{
	if (theStatusBar)
    	theStatusBar->SetHintText(NULL);
};

//
// This is it.
// Execute always shows the dialogs
//
int TMixInEnableDialog::ExecuteModally()
{
	modalActive = TRUE;
	TEnumInfo ei = { 0, 0 };
	wnds = 0;

	// Set modal state
	//
	if (!EnumTaskWindows(GetCurrentTask(), (WNDENUMPROC)EnumerateActiveWnds,
							(LPARAM)(TEnumInfo far*)&ei))
		return -1;

	// Allocate list of windows to disable, disable windows that are
	// enabled and then stuff them into the list.
	//
	ei.Wnds = wnds = new HWND[ei.Count + 1];
	memset(wnds, 0, sizeof(HWND)*(ei.Count + 1));

	EnumTaskWindows(GetCurrentTask(), (WNDENUMPROC)EnumerateActiveWnds,
							 (LPARAM)(TEnumInfo far*)&ei);

	if (Create())
	{
		if (! IsWindowVisible())
    		ShowWindow(SW_SHOW);
		executingModally = TRUE;
		if (wnds)
		for (HWND* wnd = wnds; *wnd; wnd++)
			::EnableWindow(*wnd, FALSE);
		return GetApplication()->MessageLoop();
	}
	return -1;
}

//
// If executing Modally, ensure the fake method of closing
// is used. Normally Modal and Modeless dialogs close in different
// ways. (Especially modal dialog OWL objects are not destroyed).
//
void TMixInEnableDialog::DoDestroy(int Return)
{
	if (executingModally)
	{
		modalActive = FALSE;
		//
		// Re-enable window(s) that are disabled in BeginModal()
		// before the dialog is destroyed so that application remains active
		//
		if (wnds)
			for (HWND* wnd = wnds; *wnd; wnd++)
				::EnableWindow(*wnd, TRUE);
		delete wnds;

		executingModally = FALSE;
		GetApplication()->EndModal(Return);
	}
	TWindow::Destroy(Return);
}

void TMixInEnableDialog::DoCloseWindow(int returnValue)
{
	if (executingModally) // get my variation
	{
		if (CanClose())
		{
			TransferData(tdGetData);
			Destroy(returnValue);
		}
	}
	else
		TWindow::CloseWindow(returnValue);
}


static BOOL CALLBACK EnableEnumChildProc(HWND hwnd, LPARAM lParam)
{
	HWND parent = (HWND) lParam;

	// only process controls with a valid id
	// so ignore static text with id of -1 etc
	if (parent && GetWindowWord(hwnd,GWW_ID) > 0)
	{
		TControlEnabler enabler(hwnd,parent);
		SendMessage(parent,WM_CONTROL_ENABLE,0,LPARAM(&enabler));
	}
	return TRUE;
};


BOOL TMixInEnableDialog::DoIdleAction(long idleCount)
{
	// control Enabling Stuff
	if (! idleCount)
		EnumChildWindows(HWindow,EnableEnumChildProc,(LPARAM) HWindow);

	// Help Stuff
	// Check active MDI window, or a Modal EnableDialog is running
	// this is revelant in MDI Enviroments
	if (TYPESAFE_DOWNCAST(Parent,TMDIChild))
	{
		TMDIClient *client = TYPESAFE_DOWNCAST(Parent->Parent,TMDIClient);
		if (client && (client->GetActiveMDIChild() != Parent || modalActive))
			return TWindow::IdleAction(idleCount);
	};

	// check balloon help
	if (! BHelp::On())
	{
		RemoveHelpWindow();
		return TWindow::IdleAction(idleCount);
	};
	TPoint pos;
	GetCursorPos(pos);

	// Check is in this dialog
	TRect cr = GetWindowRect();
	if (! cr.Contains(pos))
		return TWindow::IdleAction(idleCount);

	ScreenToClient(pos);
	HWND child = ChildWindowFromPoint(pos);

	int Id = ::GetWindowWord(child,GWW_ID);

	if (Id <= 0)
	{
		// no valid control
		lastControl = NULL;
		RemoveHelpWindow();
		return TWindow::IdleAction(idleCount);
	};

	if (HelpWindow && HelpWindow->HelpId() == Id)
		return TWindow::IdleAction(idleCount); // same control as lasttime

	if (! HelpWindow && lastControl == child)
	{
		// already been displayed and hidden
		RemoveHelpWindow();
		return TWindow::IdleAction(idleCount);
	};



	// new control
	if (HelpWindow)
		RemoveHelpWindow();

	TControlHelpData *Data = BHelp.FindHelp(Id);
	if (! Data)
		return TWindow::IdleAction(idleCount); // no help data

	// New Control Has Help
	if (! HandleHelp(Data))
	{
		if (theStatusBar)
		{
			if (lasthinttext != Data->text)
			{
				theStatusBar->SetHintText(Data->text.c_str());
				lasthinttext = Data->text;
			};
		}
		else
		{
			HelpWindow = new THelpWindow(this,Data,child);
			HelpWindow->Create();
		}
	};

	return TWindow::IdleAction(idleCount);
};

//**********************************************************
// Disabled Help Stuff
void TMixInEnableDialog::EvLButtonDown(UINT modKeys, TPoint& point)
{
	TWindow::EvLButtonDown(modKeys, point);
	if (DBHelp.nHelp() == 0)
		return;

	HWND child = ChildWindowFromPoint(point);
	if (::IsWindowEnabled(child))
		return; // no need

	int Id = ::GetWindowWord(child,GWW_ID);
	if (Id <= 0)
		return;

	TControlHelpData *Data = DBHelp.FindHelp(Id);
	if (! Data)
		return;

	// New Control Has Help
    RemoveHelpWindow();
	HelpWindow = new THelpWindow(this,Data,child,TRUE);
	HelpWindow->Create();
    HelpWindow->ShowWindow(SW_SHOW);

};

//**********************************************************
// Size Stuff
void TMixInEnableDialog::SizeInit()
{
	// settup initial size relationships
	TRect cr = GetClientRect();
	for (int i = 0; i < Size.SizeList.GetItemsInContainer(); i++)
	{
		TControlSizeData &data = *Size.SizeList[i];
		data.hwnd = GetDlgItem(data.Id);
		TRect r;
		::GetWindowRect(data.hwnd,&r); // screen coordinates

		// convert rectangle to client pos
		TPoint tl = r.TopLeft();
		TPoint br = r.BottomRight();
		ScreenToClient(tl);
		ScreenToClient(br);

        // Get Relative Control, if specified
		HWND cntl = NULL;
		TRect 	rr;
		TPoint	rtl;
		TPoint 	rbr;
		if (data.RelId > 0)
		{
			cntl = GetDlgItem(data.RelId);

			if (cntl)
			{
				::GetWindowRect(cntl,&rr); // screen coordinates
				// convert rectangle to client pos
				rtl = rr.TopLeft();
				rbr = rr.BottomRight();
				ScreenToClient(rtl);
				ScreenToClient(rbr);
			};
		};


		if (data.Options & AnchorRight)
		{
			if (cntl)
            	data.x = rtl.x - tl.x;
			else
				data.x = cr.right - tl.x; // dialog rhs
		};

		if (data.Options & AnchorDown)
		{
			if (cntl)
				data.y = rtl.y - tl.y;
			else
				data.y = cr.bottom - tl.y; // dialog
		};

		if (data.Options & GrowRight)
			data.cx = cr.right - br.x;

		if (data.Options & GrowDown)
			data.cy = cr.bottom - br.y;


		if (data.Options & AnchorHorizCenter)
			data.x = cr.Width() / 2 - tl.x;

		if (data.Options & AnchorVertCenter)
			data.y = cr.Height() / 2 - tl.y;

		// percentage options
		if (data.Options & AnchorHorizPercent)
			data.x = long(tl.x) * 100 / cr.Width();

		if (data.Options & AnchorVertPercent)
			data.y = long(tl.y) * 100 / cr.Height();

		if (data.Options & GrowHorizPercent)
			data.cx = long(r.Width()) * 100 / cr.Width();

		if (data.Options & GrowVertPercent)
			data.cy = long(r.Height()) * 100 / cr.Height();

		// Relative to other controls
		if (data.Options & LeftOf && cntl)
			data.x = rtl.x - tl.x;

		if (data.Options & RightOf && cntl)
			data.x = tl.x - rbr.x;

		if (data.Options & GrowLeftOf)
		{
			if (cntl)
				data.cx = rtl.x - br.x;
			else
				data.cx = cr.right - br.x; // dialog
		}
	};
};

void TMixInEnableDialog::EvSize(UINT sizeType, TSize& size)
{
	TWindow::EvSize(sizeType, size);

	TRect cr = GetClientRect();

	for (int i = 0; i < Size.SizeList.GetItemsInContainer(); i++)
	{
		TControlSizeData &data = *Size.SizeList[i];
		TRect r;
		::GetWindowRect(data.hwnd,&r); // screen coordinates

		// convert rectangle to client pos
		TPoint tl = r.TopLeft();
		TPoint br = r.BottomRight();
		ScreenToClient(tl);
		ScreenToClient(br);

		int X = tl.x;
		int Y = tl.y;
		int W = br.x - tl.x;
		int H = br.y - tl.y;

        // Get Relative Window, if specified
		HWND cntl = NULL;
		TRect 	rr;
		TPoint	rtl;
		TPoint 	rbr;
		if (data.RelId > 0)
		{
			cntl = GetDlgItem(data.RelId);

			if (cntl)
			{
				::GetWindowRect(cntl,&rr); // screen coordinates
				// convert rectangle to client pos
				rtl = rr.TopLeft();
				rbr = rr.BottomRight();
				ScreenToClient(rtl);
				ScreenToClient(rbr);
			};
		};

		if (data.Options & AnchorRight)
		{
			if (cntl)
            	X = rtl.x - data.x;
			else
				X = cr.right - data.x; // dialog
		};

		if (data.Options & AnchorDown)
		{
			if (cntl)
				Y = rtl.y - data.y;
			else
				Y = cr.bottom - data.y; // dialog
		};

		if (data.Options & GrowRight)
			W = cr.right - X - data.cx;

		if (data.Options & GrowDown)
			H = cr.bottom - Y - data.cy;

		if (data.Options & AnchorHorizCenter)
			X = cr.Width() / 2 - data.x;

		if (data.Options & AnchorVertCenter)
			Y = cr.Height() / 2 - data.y;


		// percentage options
		if (data.Options & AnchorHorizPercent)
			X = long(cr.Width()) * data.x / 100;

		if (data.Options & AnchorVertPercent)
			Y = long(cr.Height()) * data.y / 100;

		if (data.Options & GrowHorizPercent)
			W = data.cx * long(cr.Width()) / 100;

		if (data.Options & GrowVertPercent)
			H = data.cy * long(cr.Height()) / 100;

		// Relative to other controls
		if (data.Options & LeftOf && cntl)
				X = rtl.x - data.x;

		if (data.Options & RightOf && cntl)
				X = rbr.x + data.x;

		if (data.Options & GrowLeftOf)
		{
			if (cntl)
				W = (rtl.x - X) - data.cx;
			else
				W = (cr.right - X) - data.cx;
		};

		::ShowWindow(data.hwnd,SW_HIDE);
		::MoveWindow(data.hwnd,X,Y,W,H,TRUE);
		::ShowWindow(data.hwnd,SW_SHOW);
	};
};

LRESULT TMixInEnableDialog::WindowProc(UINT msg, WPARAM wParam, LPARAM lParam)
{
	// Handle our new Command, WM_CONTROL_ENABLE
	if (msg == WM_CONTROL_ENABLE)
	{
		TControlEnabler& ce = *(TControlEnabler*)lParam;

		TEventInfo  eventInfo(WM_CONTROL_ENABLE, ce.Id);
		if (Find(eventInfo))
			Dispatch(eventInfo, 0, (LPARAM)&ce);

		return 0;
	}
	else if (msg == WM_SHOWWINDOW)
	{
		LRESULT ret = TWindow::WindowProc(msg, wParam, lParam);
		SizeInit();
		return ret;
	}
	else if (msg == WM_SIZE)
	{
		EvSize(wParam,TSize(LOWORD(lParam),HIWORD(lParam)));
		return 0;
	}
	else if (msg == WM_LBUTTONDOWN)
	{
		EvLButtonDown(wParam, TPoint(LOWORD(lParam),HIWORD(lParam)));
        return 0;
	};

	return TWindow::WindowProc(msg, wParam, lParam);
};


//*********************************************************************
// Help Window Stuff
//
// 	Class:THelpWindow
//
//  Description:
//	Pops up in relative to a control & displays help
//	Automatically sizes & positions itself
//
//   Last modified date:
//   Last modified by:
//

DEFINE_RESPONSE_TABLE1(THelpWindow,TWindow)
  EV_WM_TIMER,
END_RESPONSE_TABLE;

// Help Settings
static BOOL		BHelpOn = TRUE;
static TColor	BHelpBkColor(255, 255, 128);
static TColor	BHelpTextColor(0, 0, 0);

BHelp::Style BHelp::style = BHelp::SquareBorder | BHelp::Shadow;
BYTE	BHelp::tabstops = 8;

BOOL	BHelp::On()
{
	return BHelpOn;
}

BOOL	BHelp::On(BOOL setto)
{
	BHelpOn = setto;
	return BHelpOn;
}

TColor	BHelp::BkColor()
{
	return BHelpBkColor;
}

TColor	BHelp::TextColor()
{
	return BHelpTextColor;
}

TColor	BHelp::BkColor(TColor setto)
{
	BHelpBkColor = setto;
	if (HelpWindow)
		HelpWindow->InvalidateRect(HelpWindow->GetClientRect());
	return BHelpBkColor;
}

TColor	BHelp::TextColor(TColor setto)
{
	BHelpTextColor = setto;
	if (HelpWindow)
		HelpWindow->InvalidateRect(HelpWindow->GetClientRect());
	return BHelpTextColor;
}

void BHelp::UseStatusBar(TStatusBar *sb)
{
	theStatusBar = sb;
};


// Disabled Help Settings
static BOOL		DBHelpOn = TRUE;
static TColor	DBHelpBkColor(0, 255, 255);
static TColor	DBHelpTextColor(0, 0, 255);

BOOL	DBHelp::On()
{
	return DBHelpOn;
}

BOOL	DBHelp::On(BOOL setto)
{
	DBHelpOn = setto;
	return DBHelpOn;
}

TColor	DBHelp::BkColor()
{
	return DBHelpBkColor;
}

TColor	DBHelp::TextColor()
{
	return DBHelpTextColor;
}

TColor	DBHelp::BkColor(TColor setto)
{
	DBHelpBkColor = setto;
	if (HelpWindow)
		HelpWindow->InvalidateRect(HelpWindow->GetClientRect());
	return DBHelpBkColor;
}

TColor	DBHelp::TextColor(TColor setto)
{
	DBHelpTextColor = setto;
	if (HelpWindow)
		HelpWindow->InvalidateRect(HelpWindow->GetClientRect());
	return DBHelpTextColor;
}

void TMixInEnableDialog::RemoveHelpWindow()
{
	if (! HandleHelp(NULL))
		if (theStatusBar)
		{
			theStatusBar->SetHintText(NULL);
            lasthinttext = "";
		};

	if (HelpWindow)
	{
		delete HelpWindow;
		HelpWindow = NULL;
	    lastControl = NULL;
	};
};



static HHOOK	hookKbd;				// hookchain used by KbdProc
static HHOOK	hookMouse;				// hookchain used by MouseProc
static TMixInEnableDialog
				*IdleDlg = NULL;		// Current dialog

LRESULT CALLBACK helpKbdProc (int code, WPARAM wParam, LPARAM lParam)
{
	if (code >= 0)
	{
		HWND c = lastControl;
		if (IdleDlg)
			IdleDlg->RemoveHelpWindow();
		delete HelpWindow;
		HelpWindow = NULL;
		lastControl = c;
	}

	return CallNextHookEx (hookKbd, code, wParam, lParam);
}

LRESULT CALLBACK helpMouseProc (int code, WPARAM wp, LPARAM lParam)
{
	if (code >= 0 &&
		(wp == WM_LBUTTONDOWN || wp == WM_RBUTTONDOWN || wp == WM_MBUTTONDOWN))
	{
		HWND c = lastControl;
		if (IdleDlg)
			IdleDlg->RemoveHelpWindow();
		delete HelpWindow;
		HelpWindow = NULL;
		lastControl = c;
	}

	return CallNextHookEx (hookMouse, code, wp, lParam);
}



THelpWindow::THelpWindow(TWindow *parent,TControlHelpData *help,HWND child,BOOL isDHelp) :
	TWindow(parent,""),Help(help),Child(child),IsDHelp(isDHelp)
{
	IdleDlg = TYPESAFE_DOWNCAST(parent,TMixInEnableDialog);
	Attr.Style = WS_CHILD;
	Attr.Style &= ~WS_VISIBLE;
	Attr.ExStyle = WS_EX_TOPMOST | WS_EX_TRANSPARENT;
	HelpWindow = this;

#ifdef __WIN32__
	::hookKbd		= SetWindowsHookEx (WH_KEYBOARD, helpKbdProc, NULL, GetCurrentThreadId ());
	::hookMouse		= SetWindowsHookEx (WH_MOUSE, helpMouseProc, NULL, GetCurrentThreadId ());
#else
	::hookKbd		= SetWindowsHookEx (WH_KEYBOARD, helpKbdProc, GetApplication ()->GetInstance (), GetCurrentTask ());
	::hookMouse		= SetWindowsHookEx (WH_MOUSE, helpMouseProc, GetApplication ()->GetInstance (), GetCurrentTask ());
#endif
	lastControl = Child;

};

void THelpWindow::Destroy(int retVal)
{
	KillTimer(100);
    TWindow::Destroy();
};

THelpWindow::~THelpWindow()
{
	UnhookWindowsHookEx (hookKbd);
	UnhookWindowsHookEx (hookMouse);
	HelpWindow = NULL;
	lastControl = NULL;
	IdleDlg = NULL;
};

void THelpWindow::SetupWindow()
{
	TWindow::SetupWindow();

	TRect pr = Parent->GetClientRect();
	// calculate window rect
	TWindowDC	dc(HWindow);

	TRect r(0,0,pr.Width(),pr.Height());


	// figure out text width
	dc.DrawText(Help->text.c_str(),-1,r,
		/*DT_TABSTOP| MAKEWORD(0,BHelp::SetTabStops())  |*/
		 DT_EXPANDTABS | DT_CALCRECT | DT_LEFT | DT_NOPREFIX | DT_WORDBREAK);

	// add width of borders
	r.right += 4;
	r.bottom += 4;

	// Add Shadow
	if (BHelp::SetStyle() & BHelp::Shadow)
	{
		r.right += 3;
		r.bottom += 3;
	};


	// Figure out position
	TRect cr;
	::GetWindowRect(Child,&cr);
	TPoint p = cr.TopLeft();
	ScreenToClient(p);
	r.Offset(p.x,p.y);
	int h = r.Height();
	if (r.top - h - 2 >= 0)
		r.Offset(0,-h - 2);
	else if (r.bottom + h + 2 <= pr.bottom)
		r.Offset(0,+h + 2);
	else
	{
		// high as possible
		int y = r.top;
		r.Offset(0,-y);
	};
	// check right margin
	if (r.right > pr.right)
	{
		int cx = r.right - pr.right;
		r.Offset(-cx,0);
	};


	SetWindowPos(NULL,r,SWP_NOZORDER);
	SetTimer(100,600);
};

void THelpWindow::Paint(TDC& dc, BOOL erase, TRect& rect)
{
	TRect	client;

	TBrush bBrush(! IsDHelp ? BHelp::BkColor()   : DBHelp::BkColor());
	TColor bColor(! IsDHelp ? BHelp::BkColor()   : DBHelp::BkColor());
	TColor fColor(! IsDHelp ? BHelp::TextColor() : DBHelp::TextColor());

	GetClientRect (client);

	// Cleanup the window background
	TRect r = client;
	r.right = r.left + 3;
	dc.FillRect(r,TBrush(TColor::LtGray));

	r = client;
	r.bottom = r.top + 3;
	dc.FillRect(r,TBrush(TColor::LtGray));


	dc.SelectObject (bBrush);
	dc.SetTextColor (fColor);
	dc.SetBkColor (bColor);

	if (BHelp::SetStyle() & BHelp::Shadow)
	{
		//client.right	-= 2;
		//client.bottom	-= 2;
		client.left += 3;
		client.top += 3;

		//THatch8x8Brush hb(THatch8x8Brush::Hatch11F1,TColor::LtGray);
		BYTE		byData[] = { 0x55, 0, 0xAA, 0, 0x55, 0, 0xAA, 0, 0x55, 0, 0xAA, 0, 0x55, 0, 0xAA, 0 };
		TBitmap		bm (8, 8, 1, 1, byData);
		TBrush		hb(bm);

		dc.FillRect(client, hb);

		client.left 	-= 3;
		client.top 		-= 3;
		client.right	-= 3;
		client.bottom	-= 3;
	}

	dc.SetBkMode (OPAQUE);
	TPen	pen (GetSysColor (COLOR_WINDOWFRAME));

	dc.SelectObject (pen);
	dc.SelectObject(bBrush);

	dc.Rectangle (client);

	dc.SetBkColor(bColor);
	dc.SetTextColor(fColor);
	dc.SetBkMode (TRANSPARENT);
	client.Inflate(-1,-1);
	if (Help)
		dc.DrawText(Help->text.c_str(),-1,client,
			/* DT_TABSTOP | MAKEWORD(0,BHelp::SetTabStops())  | */
			DT_EXPANDTABS | DT_LEFT | DT_NOPREFIX | DT_WORDBREAK);
};


void THelpWindow::EvTimer(UINT timerId)
{
	ShowWindow(SW_SHOW);
	KillTimer(100);
};

