		/************************************************************/
		/*                                                          */
		/*                  LIST.CPP (Turbo C++)                    */
		/*            Demos the DPRN Printer Routines               */
		/*                                                          */
		/*             Copyright 1990, Denam Systems                */
		/*                                                          */
		/************************************************************/

#include <dprn.h>
#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>

class list {
public:
	void printcode (char *whichfile);
};


/************************************************************/
/*                                                          */
/*                    Print A Text File                     */
/*                                                          */
/************************************************************/

void list::printcode (char *whichfile)
{
	printer  p;
	char     ts[90];
	char     ch;
	int      i, loc;

	ifstream in(whichfile);         // Open the file
	if (!in) {
		// File was NOT opened so tell user
		cout << "Can Not Open " << whichfile << "\n";
	}
	else {
		// File was found and opened
		cout << "Printing " << whichfile << " file.\n";
		// Set up the header line that will appear on each page
		p.headeron(TRUE);                      // off by default so turn it on
		p.putprint();                          // clear line 
		strcpy (ts, whichfile);                // save filename
		i=strlen(ts);                          // find length of ts
		for (loc=0; loc<i; loc++)
			ts[loc]=(char)toupper((int)ts[loc]); // make header uppercase
		loc=40-(int)(strlen(ts) / 2);          // center things up
		p.putprint (ts, loc);                  // save ts in print line
		p.saveheader();                        // transfer print line to header
		p.putprint();                          // make sure print line is clear
		loc=0;
		ts[loc]=(char)0;                       // nul temp line
		// Read the file until EOF
		BOOL quit=FALSE;
		do {
			in.get(ch);
			if (in) {
				switch (ch) {
					case '\t' : // Tabs (2 spaces per tab)
											ts[loc]=' ';
											loc++;
											ts[loc]=' ';
											loc++;
											break;
					case '\n' : // End of line so print it
											ts[loc]=(char)0;
											p.putprint (ts, 0);  // load printing line
											p.printline();       // print it
											p.putprint();        // clear printing line
											loc=0;
											ts[loc]=(char)0;
											break;
					case '\f' : // A formfeed was found
											p.formfeed();
											break;
					default   : // Stuff the character
											ts[loc]=ch;
											loc++;
											break;
				}
			}
			else {
				// do the last line
				quit=TRUE;
				ts[loc]=(char)0;
				p.putprint (ts, 0);  // load printing line
				p.printline();       // print it
			}
		} while (!quit);
		in.close();    // Close the file
		p.formfeed();  // spit out the last few blank page lines
	}
}  // printcode

void main (int argc, char *argv[])
{
	int  loc;
	list t;

	clrscr();                // Clear the screen
	cout << "\nLIST Program\n";
	cout << "Demo for DPRN routines\n";
	cout << "Denam Systems - Salem, OR\n\n";
	if (argc > 1) {
		for (loc=1; loc<argc; loc++)
			t.printcode (argv[loc]);
	}
	else {
		cout << "No parameters (arguments) entered. For example:\n";
		cout << "list LIST.CPP DPRN.H\n\n";
		cout << "This would print the LIST.CPP & DPRN.H files.\n";
		cout << "The printout will include a header and page number\n";
		cout << "on each page.\n";
	}
}
