/************************************************************/
/*                                                          */
/*                 EXTEND.CPP (Turbo C++)                   */
/*                                                          */
/*         Example Program For The DPRN Routines            */
/*             Copyright 1990, Denam Systems                */
/*                                                          */
/************************************************************/

#include <dprn.h>


/************************************************************/
/*                                                          */
/*                                                          */
/*            This Class Sets Extended Printing             */
/*        Features Of The Panasonic KX-P1091 Printer        */
/*                                                          */
/*                                                          */
/************************************************************/

class set1091 : public printer {
public:
	// set the Panasonic 1091 printer
	void reset (void);                // Reset the printer
	void pica (void);                 // 10 char per inch (80 per line)
	void elite (void);                // 12 char per inch (96 per line)
	void compressed (BOOL on=TRUE);   // 17 char per inch (132 per line)
	void proportional (void);         // varies
	void underline (BOOL on=TRUE);    // turn underline on/off
	void subscript (BOOL on=TRUE);    // turn subscript on/off
	void italic (BOOL on=TRUE);       // turn italic on/off
	void nlq (BOOL on=TRUE);          // turn 'Near Letter Quality' on/off
};

void set1091::reset (void)
{
	// Set default settings
	setcontrols();
	setcontrols('@');
	sendcontrols();
} // reset

void set1091::pica (void)
{
	// Pica printing
	setcontrols();
	setcontrols('P');
	sendcontrols();
} // pica

void set1091::elite (void)
{
	// Elite printing
	setcontrols();
	setcontrols('M');
	sendcontrols();
} // elite

void set1091::compressed (BOOL on)
{
	// Compressed printing
	if (on) {
		// turn it on
		setcontrols();
		setcontrols ((char) 0x0f);
		sendcontrols();
	}
	else
		// shut it off
		sendcontrols ((char) 0x12);
} // compressed

void set1091::proportional (void)
{
	// Proportional printing
	setcontrols();
	setcontrols('o');
	sendcontrols();
} // proportional

void set1091::underline (BOOL on)
{
	// Underline
	setcontrols();
	setcontrols('-');
	if (on) {
		// Turn it on
		setcontrols ((char) 0x01);
		sendcontrols();
	}
	else {
		// Turn it off
		sendcontrols();
		sendcontrols((char)0x00);
	}
}  // underline

void set1091::subscript (BOOL on)
{
	// Subscript printing
	setcontrols();
	if (on) {
		// Turn it on
		setcontrols ('S');
		setcontrols ((char) 0x01);
	}
	else
		// Shut it off
		setcontrols ('T');
	sendcontrols();
} // subscript

void set1091::italic (BOOL on)
{
	// Italic printing
	setcontrols();       // clear controls and add escape character
	if (on)
		setcontrols('4');  // italic on
	else
		setcontrols('5');  // italic off
	sendcontrols();
} // italic

void set1091::nlq (BOOL on)
{
	// Near letter quality
	pica();  // must be set to pica if near letter quality
	setcontrols();   
	if (on)
		// Turn it on
		setcontrols ('n');
	else
		// Shut it off
		setcontrols ('P');
	sendcontrols();
} // nlq

class extend {
public:
	void dopanasonic (void);
}; // extend

void extend::dopanasonic (void)
{
	// Demo the Panasonic Printer
	set1091 p;

	p.pageon(FALSE);  // Turn off page numbering
	p.putprint();
	p.putprint("Panasonic 1091 Printer Test", 26);
	p.pica();
	p.printline();
	p.putprint();
	p.putprint("This Test Might NOT Work On Your Printer", 20);
	p.printline();
	p.writeln();

	p.putprint();
	p.putprint("PICA --------- Now is the time for all good men.");
	p.pica();
	p.printline();
	p.writeln();

	p.putprint();
	p.putprint("COMPRESSED --- Now is the time for all good men.");
	p.compressed();
	p.printline();
	p.compressed(FALSE);
	p.writeln();

	p.putprint();
	p.putprint("ELITE -------- Now is the time for all good men.");
	p.elite();
	p.printline();
	p.writeln();

	p.putprint();
	p.putprint("PROPORTIONAL - Now is the time for all good men.");
	p.proportional();
	p.printline();
	p.writeln();

	p.putprint();
	p.putprint("NLQ ---------- Now is the time for all good men.");
	p.nlq();
	p.printline();
	p.nlq(FALSE);
	p.writeln();

	p.write   ("ITALIC ------- This is the ");
	p.italic();
	p.write   ("italic test to ");
	p.italic(FALSE);
	p.writeln ("see if it works.");
	p.writeln();

	p.write   ("UNDERLINE ---- This is the ");
	p.underline();
	p.write   ("underline test to");
	p.underline(FALSE);
	p.writeln (" see if it works.");
	p.writeln();

	p.write   ("SUBSCRIPT ---- This is the ");
	p.subscript();
	p.write   ("subscript test to ");
	p.subscript(FALSE);
	p.writeln ("see if it works.");
	p.writeln();

	p.formfeed();  // Spit out the last few lines
}  // dopanasonic

void main (void)
{
	extend e;

	cout << "Program to demonstrate the extended printing features\n";
	cout << "of a Panasonic KX-P1091 printer using the Denam Systems\n";
	cout << "DPRN routines for Turbo C++.\n";
	e.dopanasonic();
}
