/* 
argcargv.c -- see MSJ, May 1991, pp. 135-136

bcc -WS -G -O -Z -c -w-par winio.c wmhandlr.c argcargv.c
bcc -WS -G -O -Z -c %1.c
tlink f:\borlandc\lib\c0ws %1 argcargv winio wmhandlr,%1/c/x/Tw,null,import \
    cwins maths cs;
rc winio.res %1.exe
*/

#include "windows.h"
#include <stdlib.h>
#include <string.h>
#include "winio.h"

#ifdef __BORLANDC__
// Borland must have followed (incorrect) doc in SDK Guide, p. 14-3
#define argc _argc
#define argv _argv

extern int _argc;
extern char **_argv;
#else
// Microsoft C code per MSJ, May 1991, pp. 135-6
#define argc __argc
#define argv __argv

extern int __argc;
extern char **__argv;
#endif

extern int main(int argc, char **argv, char **envp);

HANDLE _hinst;
HANDLE _hprevinst;
LPSTR _lpcmdline;
int _ncmdshow;

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, 
    LPSTR lpCmdLine, int nCmdShow)
{
	char title[256];
	
	_hinst= hInstance;
	_hprevinst = hPrevInstance;
	_lpcmdline = lpCmdLine;
	_ncmdshow = nCmdShow;
	
	/* set up application's title bar */
	GetModuleFileName(hInstance, title, 256);
	if (lpCmdLine && *lpCmdLine)
	{
		_fstrcat(title, " ");
		_fstrcat(title, lpCmdLine);
	}
	winio_settitle(title);
	
    if (! winio_init(hInstance, hPrevInstance, nCmdShow, 0))
        return 1;
	
    return main(argc, argv, environ);
}
