
/*  DOCMEM.H  */

/*  Make sure this won't get included twice.  */
#ifndef _DOCMEM_H
#define _DOCMEM_H


 /*  Define RAM padding size.  DOCBUFFER2 -must- equal DOCBUFFER * 2  */
 #define DOCBUFFER     16
 #define DOCBUFFER2    32

 /*  Error values.  */
 #define DOC_OK         0
 #define DOC_LOWADDR    1
 #define DOC_CORRUPT    2
 #define DOC_INVALID    3
 #define DOC_OVERRUN    4
 #define DOC_UNDERRUN   5
 #define DOC_UNFREED    6
 #define DOC_USER       7
 #define DOC_UNKNOWN    8

 /*  Arbitrary identification value.  */
 #define DOCmagic     12345

 /*  Null pointer detection area.  Never make greater than DOCBUFFER!  */
 #define DOClowaddr      16


 /*  This is where we keep track of all the allocations.  */
 struct _DocMem {
   int                   magic1;  // Bound with vals we can check for
   struct _DocMem _far * next;    // Next DocMem struct in list
   struct _DocMem _far * prev;    // Prev DocMem struct in list
   void           _far * trueaddr;// The real address of the alloc
   unsigned long         truesize;// Store user size of alloc
   int                   magic2;  // Bound with vals we can check for
 };
 typedef struct _DocMem DocMem;


 /*  Extern reference in case someone wants to traverse the list.  */
 extern DocMem DOChead, DOCtail;


 /*  The function prototypes.  */
 void        DOCstart(void);
 int         DOCend(void);
 void _far * DOCfarmalloc(unsigned long nbytes);
 int         DOCfarfree(void _far *block);
 int         DOCfarassert(char *label, void _far *block);
 int         DOClog_write(char *label, int err, void _far *ptr);
 char      * DOCerr_string(int err);
 int         DOCerr_last(void);
 void        DOCerr_set(int err);



/*  End of _DOCMEM_H.  */
#endif

