/*
** CONTEXT <name> [context]
**
**	Display <name> as a typed relative name.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia.
*/

# define DSCPP_IOSTREAM

# include "dslocale.h"
# include "dscontex.h"

int main(int argc, char * argv[])
{
DSLocale	dsLocale ;
DSContext	dsContext(argc == 3 ? argv[2] : "") ;
char		canonicalName [MAX_DN_BYTES] ;
char		abbreviateName[MAX_DN_BYTES] ;
DWORD		flags = 0 ;

	if (dsLocale.status()){
		cout << "CONTEXT: Cannot initialise Unicode\n" ; return 0 ;
		}
	if (dsContext.status()){
		cout << "CONTEXT: Cannot initialise Context " << hex << dsContext.status() << "\n" ; return 0 ;
		}
	dsContext.GetContext(DCK_FLAGS,& flags) ;
	flags &= ~ DCV_TYPELESS_NAMES ;
	dsContext.SetContext(DCK_FLAGS,& flags) ;

	if (dsContext.CanonicalizeName(argv[1],canonicalName) == 0 &&
	    dsContext.AbbreviateName(canonicalName,abbreviateName) == 0)
		cout << abbreviateName << endl ;
	else
		cout << "Error " << hex << dsContext.status()
		     << " while abbreviating name " << argv[1] << endl ;

	return 0 ;
}