/*
** WOBJECT
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia.
*/
# define DSCPP_WINDOWS

# include "dslocale.h"
# include "dsobject.h"
# include "dsvchar.h"
# include "dsvint.h"
# include "dsvmulti.h"

# include <string.h>
# include <stdio.h>

/*
** dsUserAttrNames[]		Null terminated list of attribute names present
**				in the DSUserObject. The order of these names
**				is important and must be the same as used by
**				the function FindAttribute().
*/

NWPSTR	dsUserAttrNames[] = { "Surname",
			      "Full Name",
			      "Security Equals",
			      "Language", 0 } ;

/*
** dsUserAttrCount[]		Number of attribute fields in the DSUserObject
**				for each attribute listed in dsUserAttrNames[].
*/

WORD	dsUserAttrCount[] = { 1, 1, 1, 1, 0 } ;

/*
** Class DSUserObject
**
**	Used to create and read USER objects from the NDS.
*/

class DSUserObject : public DSObject
{
protected:
    DSValue *		FindAttribute(WORD attrIndex, WORD valueIndex) ;

    NWPSTR *		AttributeNames()
				{ return dsUserAttrNames ; }
    WORD *		AttributeCount()
				{ return dsUserAttrCount ; }
    NWPSTR		ClassName()
				{ return "USER" ; }
public:
    DSVString		SurName ;
    DSVString		FullName ;
    DSVMultiValue	Security ;
    DSVStringList	Language ;

			DSUserObject() { ; }
} ;

/*
** DSValue * DSUserObject::FindAttribute(WORD attrIndex, WORD)
**
**	Given an attribute index and a value index, return a pointer to the
**	DSValue object responsible for that attribute/value pair.
*/

DSValue * DSUserObject::FindAttribute(WORD attrIndex, WORD)
{
	switch (attrIndex) {
	    case 0:
		return & SurName ;
	    case 1:
		return & FullName ;
	    case 2:
		return & Security ;
	    case 3:
		return & Language ;
	    }
	return 0 ;
}

/*
** int ErrorMessage(LPSTR message, NWCCODE ccode)
**
**	Display an error message with NetWare error code.
*/

int ErrorMessage(LPSTR message, NWDSCCODE ccode = 0)
{
char buffer[256] ;

	sprintf(buffer,message,ccode) ;
	MessageBox(0,buffer,"WLOGON error",MB_OK) ;
	return 0 ;
}

int PASCAL WinMain(HINSTANCE hInstance,HINSTANCE,LPSTR cmdLine,int)
{
	DSLocale	dsLocale ;
	DSBuffer	dsBuffer ;
	DSUserObject	newUser, oldUser ;
	char		fullname[MAX_DN_BYTES],
			distname[MAX_DN_BYTES],
			context [MAX_DN_BYTES],
			everyone[MAX_DN_BYTES] ;

	if (dsLocale.status() || dsBuffer.status()){
		return ErrorMessage("OBJECT: Cannot initialise Unicode\n") ;
		}

	dsBuffer.GetContext(context) ;

	sprintf(fullname,"%s %s","test","user") ;
	sprintf(distname,".%s.%s","test",context) ;
	sprintf(everyone,"Everyone.%s",context) ;

	if (dsBuffer.DoesObjectExist(distname) == 0){
		if (newUser.ReadObject(distname,& dsBuffer)){
			return ErrorMessage("Cannot read user") ;
			}
		oldUser = newUser ;
		newUser.Language.release() ;
		newUser.Language << String("English") << String("C++")
				 << String("Pascal")  << String("Fortran") ;
		if (newUser.WriteObject(distname,& dsBuffer,& oldUser)){
			return ErrorMessage("Cannot modify user") ;
			}
		}
	else {
		newUser.SurName  << String("user")  << Syntax(SYN_CI_STRING) ;
		newUser.FullName << String(fullname) << Syntax(SYN_CI_STRING) ;
		newUser.Security << String(everyone) << Syntax(SYN_DIST_NAME) ;
		newUser.Language << String("English") ;
		if (newUser.WriteObject(distname,& dsBuffer)){
			return ErrorMessage("Cannot create user") ;
			}
		if (dsBuffer.GenerateObjectKeyPair(distname,"")){
			return ErrorMessage("Cannot generate user's RSA keys") ;
			}
		}

	return ErrorMessage("OK") ;
}