/*
** LOGON
**
**	Perform a DOS login to the NDS.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia.
*/

extern int _stklen = 8192 ;

# include "dscontext.h"
# include "dslocale.h"
# include "dsconn.h"

# include <conio.h>
# include <stdio.h>


int ErrorMessage(NWPSTR, NWDSCCODE) ;

int main(int , char * argv[])
{
DSLocale  dsLocale;
DSContext dsContext ;

	if (dsLocale.status()){
		return ErrorMessage("Cannot initialise/create unicode - %d",dsLocale.status()) ;
		}

	if (dsContext.status()){
		return ErrorMessage("Cannot initialise/create context - 0x%X",dsContext.status()) ;
		}

	char * password = getpass("Password: ") ;

	dsContext.LoginToNDS(argv[1],password) ;
	if (dsContext.status()){
		return ErrorMessage("Cannot login to NDS - 0x%X",dsContext.status()) ;
		}

	DSConn dsConn(dsContext,DSCPP_NEAREST_NDS_SERVER) ;
	if (dsConn.status())
		return ErrorMessage("Cannot connect to NDS server - 0x%X",dsConn.status()) ;

	dsConn.DeleteDriveBase(26) ;

	if (dsConn.SetDriveBase(26,"SYS:PUBLIC"))
		return ErrorMessage("Cannot map drive to SYS:PUBLIC - 0x%X",dsConn.status()) ;

	return 0 ;
}

/*
** int ErrorMessage(NWPSTR message, NWCCODE ccode)
**
**	Display an error message with NetWare error code.
*/

int ErrorMessage(NWPSTR message, NWDSCCODE ccode)
{
	printf(message,ccode) ;

	return 0 ;
}


