/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSVINT.CPP - October 1994
**
**	Definition of the DSVInteger and DSVBoolean classes.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# include "dsdefs.h"
# include "dsvalue.h"
# include "dsvint.h"

# include <stdlib.h>
# include <string.h>

/*
** NWDSCCODE DSVBoolean::assign(NWSYNTAX_ID syntaxID, void * value)
*/

NWDSCCODE DSVBoolean::assign(NWSYNTAX_ID syntaxID, void * value)
{
	if (dsValueTypeArray[(WORD)syntaxID] != DSCPP_BOOLEAN)
		return DSCPP_WRONG_TYPE ;

	Syntax = syntaxID ;
	Data   = * (BYTE *) value ;

	return 0 ;
}

/*
** NWDSCCODE DSVBoolean::compare(DSValue * value)
**
**	Compare two DSVBoolean objects. Return TRUE(1) if they are the
**	same logical value, FALSE (0) if they are not the same logical value
**	and negative for an error.
*/


NWDSCCODE DSVBoolean::compare(DSValue * value)
{
	if (checkTypeAndSyntax(value,DSCPP_BOOLEAN))
		return checkTypeAndSyntax(value,DSCPP_BOOLEAN) ;

	return (Data && 1) == (((DSVBoolean *) value)->Data && 1) ;
}

/*
** NWDSCCODE DSVInteger::assign(NWSYNTAX_ID syntaxID, void * value)
*/

NWDSCCODE DSVInteger::assign(NWSYNTAX_ID syntaxID, void * value)
{
	if (dsValueTypeArray[(WORD)syntaxID] != DSCPP_INTEGER)
		return DSCPP_WRONG_TYPE ;

	Syntax = syntaxID ;
	Data   = * (long *) value ;

	return 0 ;
}

/*
** NWPSTR DSVInteger::text()
*/

NWPSTR DSVInteger::text(int)
{
	switch (Syntax){
	    case SYN_COUNTER:
		return ultoa(Data,DSValue::Buffer,10) ;
	    case SYN_INTEGER:
		return  ltoa(Data,DSValue::Buffer,10) ;
	    case SYN_TIME:
		return strcpy(DSValue::Buffer,ctime((time_t *)& Data)) ;
	    default:
		return strcpy(DSValue::Buffer,"") ;
	    }
}

/*
** NWDSCCODE DSVInteger::compare(DSValue * value)
**
**	Compare two DSVInteger objects. Return TRUE(1) if they are the
**	same value, FALSE (0) if they are not the same value and negative
**	for an error.
*/

NWDSCCODE DSVInteger::compare(DSValue * value)
{
	if (checkTypeAndSyntax(value,DSCPP_INTEGER))
		return checkTypeAndSyntax(value,DSCPP_INTEGER) ;

	return Data == ((DSVInteger *) value)->Data ;
}

/*
** DSValue & dsChangeBoolean(DSValue & value, int data)
**
**	Modify the Data field on the DSVBoolean object. This function is
**	executed when the Boolean() stream manipulator is called.


DSValue & dsChangeBoolean(DSValue & value, int data)
{
	value.assign(SYN_BOOLEAN,& data) ;

	return value ;
}

/*
** DSValue & dsChangeInteger(DSValue & value, long data)
**
**	Modify the Data field on the DSVInteger object. This function is
**	executed when the Integer() stream manipulator is called.


DSValue & dsChangeInteger(DSValue & value, long data, NWSYNTAX_ID syntax)
{
	value.assign(syntax,& data) ;

	return value ;
}

/*
** DSValue & dsChangeCounter(DSValue & value, DWORD data)
**
**	Modify the Data field on the DSVInteger object. This function is
**	executed when the Counter() stream manipulator is called.


DSValue & dsChangeCounter(DSValue & value, DWORD data)
{
	value.assign(SYN_COUNTER,& data) ;

	return value ;
}

/*
** DSManipulator<int> Boolean(int data)
**
**	Create an instance of a manipulator object passing the address of
**	dsChangeBoolean() function so that the Data field of DSVBoolean
**	objects can be modified.
*/

DSManipulator<void *> Boolean(int data)
{
	return DSManipulator<void *>(dsChangeValue,& data,SYN_BOOLEAN) ;
}

/*
** DSManipulator<long> Integer(long data)
**
**	Create an instance of a manipulator object passing the address of
**	dsChangeInteger() function so that the Data field of DSVInteger
**	objects can be modified.
*/

DSManipulator<void *> Integer(long data)
{
	return DSManipulator<void *>(dsChangeValue,& data,SYN_INTEGER) ;
}

/*
** DSManipulator<DWORD> Counter(DWORD data)
**
**	Create an instance of a manipulator object passing the address of
**	dsChangeCounter() function so that the Data field of DSVInteger
**	objects can be modified.
*/

DSManipulator<void *> Counter(DWORD data)
{
	return DSManipulator<void *>(dsChangeValue,& data,SYN_COUNTER) ;
}

/*
** DSManipulator<DWORD> Time(time_t data)
**
**	Create an instance of a manipulator object passing the address of
**	dsChangeInteger() function so that the Data field of DSVInteger
**	objects can be modified.
*/

DSManipulator<void *> Time(time_t data)
{
	return DSManipulator<void *>(dsChangeValue,& data,SYN_TIME) ;
}

