/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSSCHEME.CPP - October 1994
**
**	Access and modify the NDS schema.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# include "dsdefs.h"
# include "dsschema.h"
# include "dsiterat.h"
# include <mem.h>
# include <string.h>

/*
** NWDSCCODE DSSchema::DefineClass(
**			NWPSTR		classDetails[],
**			NWCLASS_INFO *	classInfo)
**
**	Define a new NDS schema class. Class definitions consist of a class
**	name and five groups of NDS attributes (Super classes, Containment
**	classes, Naming attributes, Mandatory attributes and Optional
**	attributes). These properties are listed the classDetails parameter in
**	the following format
**
**		Class Name,
**		Super class, ... , 0
**		Containment class, ... , 0
**		Naming class, ... , 0
**		Mandatory attribute, ... , 0
**		Optional attribute, ... 0
**
**	All sections must be defined, the NULL pointer must be given even if
**	a section is empty.
*/

NWDSCCODE DSSchema::DefineClass(NWPSTR classDetails[], NWCLASS_INFO * classInfo)
{
short	attr = 0 ;

	DSInput::InitBuf(DSV_DEFINE_CLASS) ;

	for (short i = 0 ; i < 5 ; i++){
		BeginClassItem() ;
		while (classDetails[++attr])
			PutClassItem(classDetails[attr]) ;
		}

	return Status = DefineClass(classDetails[0],classInfo) ;
}

/*
** NWDSCCODE DSSchema::DefineClass(
**			NWPSTR		classDetails[],
**			NWDS_FLAGS	classFlags = DS_EFFECTIVE_CLASS)
**
**	Define a new NDS schema class.
*/

NWDSCCODE DSSchema::DefineClass(NWPSTR classDetails[], NWDS_FLAGS classFlags)
{
NWCLASS_INFO	classInfo ;

	classInfo.classFlags    = classFlags ;
	classInfo.asn1ID.length = 8 ;
	memset(classInfo.asn1ID.data,0,8) ;

	return DefineClass(classDetails,& classInfo) ;
}

/*
** NWDSCCODE DSSchema::ListContainableClasses(
**			NWPSTR		parent,
**			DSIteration *	iteration)
**
**	List the classes that can be contained in a parent object.
**	NWDSListContainableClasses iteration is managed by using a DSIteration
**	object. Developers should derive their own classes from DSIteration
**	and override the class's functions to receive the results.
**
**	DSIteration Protocol:
**		InitLoop()
**		For each class type
**			SetAttrName(ClassSchemaName,0)
**		ExitLoop(Status)
*/

NWDSCCODE DSSchema::ListContainableClasses(NWPSTR parent, DSIteration * iteration)
{
NWDS_ITERATION	iterHandle = -1 ;

	InitLoop(iteration) ;

	do {
		Status = NWDSListContainableClasses(dContext,parent,& iterHandle,Output) ;

		if (Status || ListClassItems(iteration)) break ;

	} while (iterHandle != -1) ;

	ExitLoop(iteration) ;

	if (Status > 0) CloseIteration(iterHandle,DSV_LIST_CONTAINABLE_CLASSES) ;

	return Status ;
}

/*
** NWDSCCODE DSSchema::ReadAttrDef(
**			NWDS_TYPE	infoType,
**			NWFLAGS		allAttrs,
**			DSIteration *	iteration)
**
**	List the attribute definitions of the specified attributes.
**	NWDSReadAttrDef iteration is managed by using a DSIteration
**	object. Developers should derive their own classes from DSIteration
**	and override the class's functions to receive the results.
**
**	DSIteration Protocol:
**		InitLoop()
**		For each attribute
**			InitObject(AttrSchemaName,AttrInformation)
**			ExitObject(AttrSchemaName)
**		ExitLoop(Status)
*/

NWDSCCODE DSSchema::ReadAttrDef(NWDS_TYPE infoType, NWFLAGS allAttrs, DSIteration * iteration)
{
NWDS_ITERATION	iterHandle = -1 ;

	InitLoop(iteration) ;

	do {
		Status = NWDSReadAttrDef(dContext,infoType,allAttrs,Input,& iterHandle,Output) ;

		if (Status || ListAttrDef(iteration)) break ;

	} while (iterHandle != -1) ;

	ExitLoop(iteration) ;

	if (Status > 0) CloseIteration(iterHandle,DSV_READ_ATTR_DEF) ;

	return Status ;
}

/*
** NWDSCCODE DSSchema::ReadClassDef(
**			NWDS_TYPE	infoType,
**			NWFLAGS		allClasses,
**			DSIteration *	iteration)
**
**	List the class definitions of the specified classes.
**	NWDSReadClassDef iteration is managed by using a DSIteration
**	object. Developers should derive their own classes from DSIteration
**	and override the class's functions to receive the results.
**
**	DSIteration Protocol:
**		InitLoop()
**		For each class
**			InitObject(ClassSchemaName,ClassInformation)
**			if full information requested
**				for i = 0 to 4 do
**					SetAttrName(ClassSchemaName,i)
**			ExitObject(ClassSchemaName)
**		ExitLoop(Status)
*/

NWDSCCODE DSSchema::ReadClassDef(NWDS_TYPE infoType, NWFLAGS allClasses, DSIteration * iteration)
{
NWDS_ITERATION	iterHandle = -1 ;

	InitLoop(iteration) ;

	do {
		Status = NWDSReadClassDef(dContext,infoType,allClasses,Input,& iterHandle,Output) ;

		if (Status || ListClassDef(iteration,infoType)) break ;

	} while (iterHandle != -1) ;

	ExitLoop(iteration) ;

	if (Status > 0) CloseIteration(iterHandle,DSV_READ_CLASS_DEF) ;

	return Status ;
}

/*
** NWDSCCODE DSSchema::ReadSyntaxes(
**			NWDS_TYPE	infoType,
**			NWFLAGS		allClasses,
**			DSIteration *	iteration)
**
**	List the syntax definitions of the specified schema syntaxes.
**	NWDSReadSyntaxes iteration is managed by using a DSIteration
**	object. Developers should derive their own classes from DSIteration
**	and override the class's functions to receive the results.
**
**	DSIteration Protocol:
**		InitLoop()
**		For each syntax
**			InitObject(SyntaxSchemaName,SyntaxInformation)
**			ExitObject(SyntaxSchemaName)
**		ExitLoop(Status)
*/

NWDSCCODE DSSchema::ReadSyntaxes(NWDS_TYPE infoType, NWFLAGS allSyntaxes, DSIteration * iteration)
{
NWDS_ITERATION	iterHandle = -1 ;

	InitLoop(iteration) ;

	do {
		Status = NWDSReadSyntaxes(dContext,infoType,allSyntaxes,Input,& iterHandle,Output) ;

		if (Status || ListSyntaxes(iteration)) break ;


	} while (iterHandle != -1) ;

	ExitLoop(iteration) ;

	if (Status > 0) CloseIteration(iterHandle,DSV_READ_SYNTAXES) ;

	return Status ;
}

/*
** NWDSCCODE DSSchema::ListClassItems(
**			DSIteration *	iteration,
**			NWSYNTAX_ID	type = 0)
**
**	Unload all class item entries from the buffer.
*/

NWDSCCODE DSSchema::ListClassItems(DSIteration * iteration, NWSYNTAX_ID type)
{
NWCOUNT	itemCount ;

	GetClassItemCount(itemCount) ;

	for (short i = 0 ; Status == 0 && i < itemCount ; i++){
		if (GetClassItem(ObjectAttr) == 0)
		    SetAttrName(iteration,ObjectAttr,type) ;
		}
	return Status ;
}

/*
** NWDSCCODE DSSchema::ListAttrDef(DSIteration * iteration)
**
**	Unload all attribute definitions from the buffer.
*/

NWDSCCODE DSSchema::ListAttrDef(DSIteration * iteration)
{
NWCOUNT		itemCount = 0 ;
NWATTR_INFO	attrInfo ;

	GetAttrCount(itemCount) ;

	for (short i = 0 ; Status == 0 && i < itemCount ; i++){
		if (GetAttrDef(ObjectName,& attrInfo) == 0)
			InitObject(iteration,ObjectName,& attrInfo) ;
		}
	return Status ;
}

/*
** NWDSCCODE DSSchema::ListClassDef(DSIteration * iteration, NWDS_TYPE infoType)
**
**	Unload all class definitions from the buffer.
*/

NWDSCCODE DSSchema::ListClassDef(DSIteration * iteration, NWDS_TYPE infoType)
{
NWCOUNT		itemCount = 0 ;
NWCLASS_INFO	classInfo ;

	GetClassDefCount(itemCount) ;

	for (short i = 0 ; Status == 0 && i < itemCount ; i++){
		if (GetClassDef(ObjectName,& classInfo) == 0)
			InitObject(iteration,ObjectName,& classInfo) ;
		if (infoType == DS_CLASS_DEFS || infoType == DS_EXPANDED_CLASS_DEFS)
			for (short j = 0 ; Status == 0 && j < 5 ; j++)
				Status = ListClassItems(iteration,j) ;
		}
	return Status ;
}

/*
** NWDSCCODE DSSchema::ListSyntaxes(DSIteration * iteration)
**
**	Unload all syntax definitions from the buffer.
*/

NWDSCCODE DSSchema::ListSyntaxes(DSIteration * iteration)
{
NWCOUNT		itemCount = 0 ;
NWSYNTAX_INFO	syntaxInfo ;

	GetSyntaxCount(itemCount) ;

	for (short i = 0 ; Status == 0 || i < itemCount ; i++){
		if (GetSyntaxDef(ObjectName,& syntaxInfo) == 0)
			InitObject(iteration,ObjectName,& syntaxInfo) ;
		}
	return Status ;
}

