/*
**	Copyright  1994 Novell, Inc.  All rights reserved.
**
**	Permission is granted to the recipient of this work ("you") to use,
**	reproduce and distribute Novell's original publication of the work free
**	of charge provided that you reproduce the work in its entirety and
**	include all Novell copyright notices as they originally appear.
**
**	Novell grants you permission to modify and distribute copies of this
**	work including any portion of this work (a "modified work") provided
**	that you include prominent notification of such modification along with
**	the date of modification on a modified work; distribute or publish a
**	modified work to third parties under the same conditions and granting
**	the same rights as are extended to you by Novell under this under
**	permission notice; and provided that you include a copy of Novell's
**	original publication of the work along with any copy of a modified
**	work.
**
**	NOVELL MAKES NO WARRANTY, REPRESENTATION OR PROMISE THAT THIS WORK OR A
**	MODIFIED WORK WILL SATISFY YOUR REQUIREMENTS OR THAT THIS WORK OR A
**	MODIFIED WORK IS WITHOUT DEFECT OR ERROR.  NOVELL DISCLAIMS AND
**	EXCLUDES ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY, TITLE OR
**	FITNESS FOR A PARTICULAR PURPOSE.
**
**	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW WILL NOVELL OR ANY OTHER
**	PARTY BE LIABLE FOR DAMAGES INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
**	CONSEQUENTIAL, INDIRECT OR PUNATIVE DAMAGES ARISING OUT OF THE USE OF
**	OR INABLITITY TO USE THE WORK OR A MODIFIED WORK.
**
**	DSPARTIT.H - October 1994
**
**	Declaration of the DSPartition class.
**
**	Author: John Buckle, Asia Pacific Support Centre, Novell Australia
**	==================================================================
**	9 Jan 1995           First release              John Buckle
*/

# ifndef dsPARTIT_H
# define dsPARTIT_H

# include "dsbuffer.h"

/*
** Class DSPartition
**
**	Used to access the partition and replica APIs for Directory Services.
**	The assignment operator and initialisation contructor are declared
**	but not defined, this is to stop the directory buffer being copied
**	and inadvertantly released.
*/

class _DSCLASSDEC DSPartition : public virtual DSBuffer
{
protected:

public:
			DSPartition(
				NWPSTR	context    = 0,
				DWORD	flags      = DSCPP_CONTEXT_FLAGS,
				WORD	inputSize  = DEFAULT_MESSAGE_LEN,
				WORD	outputSize = DEFAULT_MESSAGE_LEN,
				WORD	filterSize = DEFAULT_MESSAGE_LEN) :
					DSBuffer(context,flags,inputSize,outputSize,filterSize)
				{ ; }
			DSPartition(DSPartition &) ;
	virtual	      ~ DSPartition() { ; }
	void		operator=(DSPartition &) ;

	NWDSCCODE	AbortPartitionOperation(NWPSTR root)
				{ return Status = NWDSAbortPartitionOperation(dContext,root) ; }
	NWDSCCODE	AddPartition(NWPSTR server, NWPSTR root, NWFLAGS more = 0) ;

	NWDSCCODE	AddReplica(NWPSTR server, NWPSTR root, NWREPLICA_TYPE type)
				{ return Status = NWDSAddReplica(dContext,server,root,type) ; }
	NWDSCCODE	ChangeReplicaType(NWPSTR replica, NWPSTR server, NWREPLICA_TYPE type)
				{ return Status = NWDSChangeReplicaType(dContext,replica,server,type) ; }
	NWDSCCODE	GetPartitionInfo(NWPSTR name, NWREPLICA_TYPE & type)
				{ return Status = NWDSGetPartitionInfo(dContext,Output,name,& type) ; }
	NWDSCCODE	GetPartitionRoot(NWPSTR object, NWPSTR partition)
				{ return Status = NWDSGetPartitionRoot(dContext,object,partition) ; }
	NWDSCCODE	GetServerName(NWPSTR name, NWCOUNT & count)
				{ return Status = NWDSGetServerName(dContext,Output,name,& count) ; }
	NWDSCCODE	JoinPartitions(NWPSTR subordinate)
				{ return Status = NWDSJoinPartitions(dContext,subordinate,0) ; }
	NWDSCCODE	ListPartitions(NWPSTR server, DSIteration * iteration) ;

	NWDSCCODE	PartitionReceiveAllUpdates(NWPSTR root, NWPSTR server)
				{ return Status = NWDSPartitionReceiveAllUpdates(dContext,root,server) ; }
	NWDSCCODE	RemovePartition(NWPSTR root)
				{ return Status = NWDSRemovePartition(dContext,root) ; }
	NWDSCCODE	RemoveReplica(NWPSTR server, NWPSTR root)
				{ return Status = NWDSRemoveReplica(dContext,server,root) ; }
	NWDSCCODE	RepairTimeStamps(NWPSTR root)
				{ return Status = NWDSRepairTimeStamps(dContext,root) ; }
	NWDSCCODE	PartitionSendAllUpdates(NWPSTR root, NWPSTR server)
				{ return Status = NWDSPartitionSendAllUpdates(dContext,root,server) ; }
	NWDSCCODE	SplitPartition(NWPSTR subordinate)
				{ return Status = NWDSSplitPartition(dContext,subordinate,0) ; }
	NWDSCCODE	SyncPartition(NWPSTR server, NWPSTR root, DWORD seconds)
				{ return Status = NWDSSyncPartition(dContext,server,root,seconds) ; }
} ;

# endif dsPARTIT_H
